/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AgentOptions;
import com.azure.resourcemanager.networkcloud.models.AgentPool;
import com.azure.resourcemanager.networkcloud.models.AgentPoolDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.AgentPoolMode;
import com.azure.resourcemanager.networkcloud.models.AgentPoolPatchParameters;
import com.azure.resourcemanager.networkcloud.models.AgentPoolProvisioningState;
import com.azure.resourcemanager.networkcloud.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.networkcloud.models.AttachedNetworkConfiguration;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KubernetesLabel;
import com.azure.resourcemanager.networkcloud.models.NodePoolAdministratorConfigurationPatch;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class AgentPoolImpl
implements AgentPool,
AgentPool.Definition,
AgentPool.Update {
    private AgentPoolInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String kubernetesClusterName;
    private String agentPoolName;
    private AgentPoolPatchParameters updateAgentPoolUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AdministratorConfiguration administratorConfiguration() {
        return this.innerModel().administratorConfiguration();
    }

    @Override
    public AgentOptions agentOptions() {
        return this.innerModel().agentOptions();
    }

    @Override
    public AttachedNetworkConfiguration attachedNetworkConfiguration() {
        return this.innerModel().attachedNetworkConfiguration();
    }

    @Override
    public List<String> availabilityZones() {
        List<String> inner = this.innerModel().availabilityZones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public long count() {
        return this.innerModel().count();
    }

    @Override
    public AgentPoolDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public String kubernetesVersion() {
        return this.innerModel().kubernetesVersion();
    }

    @Override
    public List<KubernetesLabel> labels() {
        List<KubernetesLabel> inner = this.innerModel().labels();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public AgentPoolMode mode() {
        return this.innerModel().mode();
    }

    @Override
    public AgentPoolProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<KubernetesLabel> taints() {
        List<KubernetesLabel> inner = this.innerModel().taints();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.innerModel().upgradeSettings();
    }

    @Override
    public String vmSkuName() {
        return this.innerModel().vmSkuName();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AgentPoolInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public AgentPoolImpl withExistingKubernetesCluster(String resourceGroupName, String kubernetesClusterName) {
        this.resourceGroupName = resourceGroupName;
        this.kubernetesClusterName = kubernetesClusterName;
        return this;
    }

    @Override
    public AgentPool create() {
        this.innerObject = this.serviceManager.serviceClient().getAgentPools().createOrUpdate(this.resourceGroupName, this.kubernetesClusterName, this.agentPoolName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AgentPool create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAgentPools().createOrUpdate(this.resourceGroupName, this.kubernetesClusterName, this.agentPoolName, this.innerModel(), context);
        return this;
    }

    AgentPoolImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new AgentPoolInner();
        this.serviceManager = serviceManager;
        this.agentPoolName = name;
    }

    @Override
    public AgentPoolImpl update() {
        this.updateAgentPoolUpdateParameters = new AgentPoolPatchParameters();
        return this;
    }

    @Override
    public AgentPool apply() {
        this.innerObject = this.serviceManager.serviceClient().getAgentPools().update(this.resourceGroupName, this.kubernetesClusterName, this.agentPoolName, this.updateAgentPoolUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public AgentPool apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAgentPools().update(this.resourceGroupName, this.kubernetesClusterName, this.agentPoolName, this.updateAgentPoolUpdateParameters, context);
        return this;
    }

    AgentPoolImpl(AgentPoolInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "kubernetesClusters");
        this.agentPoolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "agentPools");
    }

    @Override
    public AgentPool refresh() {
        this.innerObject = (AgentPoolInner)((Object)this.serviceManager.serviceClient().getAgentPools().getWithResponse(this.resourceGroupName, this.kubernetesClusterName, this.agentPoolName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AgentPool refresh(Context context) {
        this.innerObject = (AgentPoolInner)((Object)this.serviceManager.serviceClient().getAgentPools().getWithResponse(this.resourceGroupName, this.kubernetesClusterName, this.agentPoolName, context).getValue());
        return this;
    }

    @Override
    public AgentPoolImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public AgentPoolImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public AgentPoolImpl withCount(long count) {
        this.innerModel().withCount(count);
        return this;
    }

    @Override
    public AgentPoolImpl withMode(AgentPoolMode mode) {
        this.innerModel().withMode(mode);
        return this;
    }

    @Override
    public AgentPoolImpl withVmSkuName(String vmSkuName) {
        this.innerModel().withVmSkuName(vmSkuName);
        return this;
    }

    @Override
    public AgentPoolImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateAgentPoolUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public AgentPoolImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public AgentPoolImpl withAdministratorConfiguration(AdministratorConfiguration administratorConfiguration) {
        this.innerModel().withAdministratorConfiguration(administratorConfiguration);
        return this;
    }

    @Override
    public AgentPoolImpl withAgentOptions(AgentOptions agentOptions) {
        this.innerModel().withAgentOptions(agentOptions);
        return this;
    }

    @Override
    public AgentPoolImpl withAttachedNetworkConfiguration(AttachedNetworkConfiguration attachedNetworkConfiguration) {
        this.innerModel().withAttachedNetworkConfiguration(attachedNetworkConfiguration);
        return this;
    }

    @Override
    public AgentPoolImpl withAvailabilityZones(List<String> availabilityZones) {
        this.innerModel().withAvailabilityZones(availabilityZones);
        return this;
    }

    @Override
    public AgentPoolImpl withLabels(List<KubernetesLabel> labels) {
        this.innerModel().withLabels(labels);
        return this;
    }

    @Override
    public AgentPoolImpl withTaints(List<KubernetesLabel> taints) {
        this.innerModel().withTaints(taints);
        return this;
    }

    @Override
    public AgentPoolImpl withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        if (this.isInCreateMode()) {
            this.innerModel().withUpgradeSettings(upgradeSettings);
            return this;
        }
        this.updateAgentPoolUpdateParameters.withUpgradeSettings(upgradeSettings);
        return this;
    }

    @Override
    public AgentPoolImpl withAdministratorConfiguration(NodePoolAdministratorConfigurationPatch administratorConfiguration) {
        this.updateAgentPoolUpdateParameters.withAdministratorConfiguration(administratorConfiguration);
        return this;
    }

    @Override
    public AgentPoolImpl withCount(Long count) {
        this.updateAgentPoolUpdateParameters.withCount(count);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

