/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.L3NetworkProperties;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksIpamEnabled;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.IpAllocationType;
import com.azure.resourcemanager.networkcloud.models.L3NetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.L3NetworkProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class L3NetworkInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private L3NetworkProperties innerProperties = new L3NetworkProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(L3NetworkInner.class);

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public L3NetworkInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private L3NetworkProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public L3NetworkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public L3NetworkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<String> associatedResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedResourceIds();
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public L3NetworkDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksClustersAssociatedIds();
    }

    public HybridAksIpamEnabled hybridAksIpamEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksIpamEnabled();
    }

    public L3NetworkInner withHybridAksIpamEnabled(HybridAksIpamEnabled hybridAksIpamEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L3NetworkProperties();
        }
        this.innerProperties().withHybridAksIpamEnabled(hybridAksIpamEnabled);
        return this;
    }

    public HybridAksPluginType hybridAksPluginType() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksPluginType();
    }

    public L3NetworkInner withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L3NetworkProperties();
        }
        this.innerProperties().withHybridAksPluginType(hybridAksPluginType);
        return this;
    }

    public String interfaceName() {
        return this.innerProperties() == null ? null : this.innerProperties().interfaceName();
    }

    public L3NetworkInner withInterfaceName(String interfaceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L3NetworkProperties();
        }
        this.innerProperties().withInterfaceName(interfaceName);
        return this;
    }

    public IpAllocationType ipAllocationType() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAllocationType();
    }

    public L3NetworkInner withIpAllocationType(IpAllocationType ipAllocationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L3NetworkProperties();
        }
        this.innerProperties().withIpAllocationType(ipAllocationType);
        return this;
    }

    public String ipv4ConnectedPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().ipv4ConnectedPrefix();
    }

    public L3NetworkInner withIpv4ConnectedPrefix(String ipv4ConnectedPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L3NetworkProperties();
        }
        this.innerProperties().withIpv4ConnectedPrefix(ipv4ConnectedPrefix);
        return this;
    }

    public String ipv6ConnectedPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().ipv6ConnectedPrefix();
    }

    public L3NetworkInner withIpv6ConnectedPrefix(String ipv6ConnectedPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L3NetworkProperties();
        }
        this.innerProperties().withIpv6ConnectedPrefix(ipv6ConnectedPrefix);
        return this;
    }

    public String l3IsolationDomainId() {
        return this.innerProperties() == null ? null : this.innerProperties().l3IsolationDomainId();
    }

    public L3NetworkInner withL3IsolationDomainId(String l3IsolationDomainId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L3NetworkProperties();
        }
        this.innerProperties().withL3IsolationDomainId(l3IsolationDomainId);
        return this;
    }

    public L3NetworkProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachinesAssociatedIds();
    }

    public long vlan() {
        return this.innerProperties() == null ? 0L : this.innerProperties().vlan();
    }

    public L3NetworkInner withVlan(long vlan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L3NetworkProperties();
        }
        this.innerProperties().withVlan(vlan);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model L3NetworkInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model L3NetworkInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static L3NetworkInner fromJson(JsonReader jsonReader) throws IOException {
        return (L3NetworkInner)((Object)jsonReader.readObject(reader -> {
            L3NetworkInner deserializedL3NetworkInner = new L3NetworkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedL3NetworkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedL3NetworkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedL3NetworkInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedL3NetworkInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedL3NetworkInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedL3NetworkInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedL3NetworkInner.innerProperties = L3NetworkProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedL3NetworkInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL3NetworkInner;
        }));
    }
}

