/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterMetricsConfigurationProperties;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ClusterMetricsConfigurationInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private ClusterMetricsConfigurationProperties innerProperties = new ClusterMetricsConfigurationProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterMetricsConfigurationInner.class);

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public ClusterMetricsConfigurationInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private ClusterMetricsConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ClusterMetricsConfigurationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ClusterMetricsConfigurationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public long collectionInterval() {
        return this.innerProperties() == null ? 0L : this.innerProperties().collectionInterval();
    }

    public ClusterMetricsConfigurationInner withCollectionInterval(long collectionInterval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterMetricsConfigurationProperties();
        }
        this.innerProperties().withCollectionInterval(collectionInterval);
        return this;
    }

    public ClusterMetricsConfigurationDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public List<String> disabledMetrics() {
        return this.innerProperties() == null ? null : this.innerProperties().disabledMetrics();
    }

    public List<String> enabledMetrics() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledMetrics();
    }

    public ClusterMetricsConfigurationInner withEnabledMetrics(List<String> enabledMetrics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterMetricsConfigurationProperties();
        }
        this.innerProperties().withEnabledMetrics(enabledMetrics);
        return this;
    }

    public ClusterMetricsConfigurationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model ClusterMetricsConfigurationInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ClusterMetricsConfigurationInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ClusterMetricsConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterMetricsConfigurationInner)((Object)jsonReader.readObject(reader -> {
            ClusterMetricsConfigurationInner deserializedClusterMetricsConfigurationInner = new ClusterMetricsConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterMetricsConfigurationInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationInner.innerProperties = ClusterMetricsConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterMetricsConfigurationInner;
        }));
    }
}

