/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterManagerProperties;
import com.azure.resourcemanager.networkcloud.models.ClusterAvailableVersion;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ClusterManagerInner
extends Resource {
    private ManagedServiceIdentity identity;
    private ClusterManagerProperties innerProperties = new ClusterManagerProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterManagerInner.class);

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ClusterManagerInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ClusterManagerProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ClusterManagerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ClusterManagerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String analyticsWorkspaceId() {
        return this.innerProperties() == null ? null : this.innerProperties().analyticsWorkspaceId();
    }

    public ClusterManagerInner withAnalyticsWorkspaceId(String analyticsWorkspaceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterManagerProperties();
        }
        this.innerProperties().withAnalyticsWorkspaceId(analyticsWorkspaceId);
        return this;
    }

    public List<String> availabilityZones() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZones();
    }

    public ClusterManagerInner withAvailabilityZones(List<String> availabilityZones) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterManagerProperties();
        }
        this.innerProperties().withAvailabilityZones(availabilityZones);
        return this;
    }

    public List<ClusterAvailableVersion> clusterVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterVersions();
    }

    public ClusterManagerDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public String fabricControllerId() {
        return this.innerProperties() == null ? null : this.innerProperties().fabricControllerId();
    }

    public ClusterManagerInner withFabricControllerId(String fabricControllerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterManagerProperties();
        }
        this.innerProperties().withFabricControllerId(fabricControllerId);
        return this;
    }

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().managedResourceGroupConfiguration();
    }

    public ClusterManagerInner withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterManagerProperties();
        }
        this.innerProperties().withManagedResourceGroupConfiguration(managedResourceGroupConfiguration);
        return this;
    }

    public ExtendedLocation managerExtendedLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().managerExtendedLocation();
    }

    public ClusterManagerProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String vmSize() {
        return this.innerProperties() == null ? null : this.innerProperties().vmSize();
    }

    public ClusterManagerInner withVmSize(String vmSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterManagerProperties();
        }
        this.innerProperties().withVmSize(vmSize);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ClusterManagerInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ClusterManagerInner fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterManagerInner)((Object)jsonReader.readObject(reader -> {
            ClusterManagerInner deserializedClusterManagerInner = new ClusterManagerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClusterManagerInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClusterManagerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClusterManagerInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedClusterManagerInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterManagerInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClusterManagerInner.innerProperties = ClusterManagerProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedClusterManagerInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedClusterManagerInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterManagerInner;
        }));
    }
}

