/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointPropertiesInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.PrivateEndpointIpConfiguration;
import com.azure.resourcemanager.network.models.PrivateEndpointIpVersionType;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnection;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PrivateEndpointInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private PrivateEndpointPropertiesInner innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public PrivateEndpointInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private PrivateEndpointPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public PrivateEndpointInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public PrivateEndpointInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PrivateEndpointInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubnetInner subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public PrivateEndpointInner withSubnet(SubnetInner subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaces();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PrivateEndpointIpVersionType ipVersionType() {
        return this.innerProperties() == null ? null : this.innerProperties().ipVersionType();
    }

    public PrivateEndpointInner withIpVersionType(PrivateEndpointIpVersionType ipVersionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withIpVersionType(ipVersionType);
        return this;
    }

    public List<PrivateLinkServiceConnection> privateLinkServiceConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnections();
    }

    public PrivateEndpointInner withPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> privateLinkServiceConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withPrivateLinkServiceConnections(privateLinkServiceConnections);
        return this;
    }

    public List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().manualPrivateLinkServiceConnections();
    }

    public PrivateEndpointInner withManualPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withManualPrivateLinkServiceConnections(manualPrivateLinkServiceConnections);
        return this;
    }

    public List<CustomDnsConfigPropertiesFormat> customDnsConfigs() {
        return this.innerProperties() == null ? null : this.innerProperties().customDnsConfigs();
    }

    public PrivateEndpointInner withCustomDnsConfigs(List<CustomDnsConfigPropertiesFormat> customDnsConfigs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withCustomDnsConfigs(customDnsConfigs);
        return this;
    }

    public List<ApplicationSecurityGroupInner> applicationSecurityGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationSecurityGroups();
    }

    public PrivateEndpointInner withApplicationSecurityGroups(List<ApplicationSecurityGroupInner> applicationSecurityGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withApplicationSecurityGroups(applicationSecurityGroups);
        return this;
    }

    public List<PrivateEndpointIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public PrivateEndpointInner withIpConfigurations(List<PrivateEndpointIpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public String customNetworkInterfaceName() {
        return this.innerProperties() == null ? null : this.innerProperties().customNetworkInterfaceName();
    }

    public PrivateEndpointInner withCustomNetworkInterfaceName(String customNetworkInterfaceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withCustomNetworkInterfaceName(customNetworkInterfaceName);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointInner fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointInner)((Object)jsonReader.readObject(reader -> {
            PrivateEndpointInner deserializedPrivateEndpointInner = new PrivateEndpointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPrivateEndpointInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateEndpointInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPrivateEndpointInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPrivateEndpointInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedPrivateEndpointInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateEndpointInner.innerProperties = PrivateEndpointPropertiesInner.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPrivateEndpointInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedPrivateEndpointInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointInner;
        }));
    }
}

