/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import java.io.IOException;
import java.util.List;

public final class RouteTableListResult
implements JsonSerializable<RouteTableListResult> {
    private List<RouteTableInner> value;
    private String nextLink;

    public List<RouteTableInner> value() {
        return this.value;
    }

    public RouteTableListResult withValue(List<RouteTableInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public RouteTableListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static RouteTableListResult fromJson(JsonReader jsonReader) throws IOException {
        return (RouteTableListResult)jsonReader.readObject(reader -> {
            RouteTableListResult deserializedRouteTableListResult = new RouteTableListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedRouteTableListResult.value = value = reader.readArray(reader1 -> RouteTableInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedRouteTableListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteTableListResult;
        });
    }
}

