/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.VirtualNetworkGatewaysClient;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import com.azure.resourcemanager.network.implementation.PagedConverterForMergedPagedFlux;
import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewayImpl;
import com.azure.resourcemanager.network.models.VirtualNetworkGateway;
import com.azure.resourcemanager.network.models.VirtualNetworkGateways;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class VirtualNetworkGatewaysImpl
extends GroupableResourcesImpl<VirtualNetworkGateway, VirtualNetworkGatewayImpl, VirtualNetworkGatewayInner, VirtualNetworkGatewaysClient, NetworkManager>
implements VirtualNetworkGateways {
    public VirtualNetworkGatewaysImpl(NetworkManager networkManager) {
        super((Object)((NetworkManagementClient)networkManager.serviceClient()).getVirtualNetworkGateways(), (Manager)networkManager);
    }

    public VirtualNetworkGatewayImpl define(String name) {
        return this.wrapModel(name);
    }

    public PagedIterable<VirtualNetworkGateway> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<VirtualNetworkGateway> listAsync() {
        return PagedConverterForMergedPagedFlux.mapPage(PagedConverter.mergePagedFlux((PagedFlux)((NetworkManager)this.manager()).resourceManager().resourceGroups().listAsync(), rg -> ((VirtualNetworkGatewaysClient)this.inner()).listByResourceGroupAsync(rg.name())), this::wrapModel);
    }

    public PagedIterable<VirtualNetworkGateway> listByResourceGroup(String groupName) {
        return new PagedIterable(this.listByResourceGroupAsync(groupName));
    }

    public PagedFlux<VirtualNetworkGateway> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return new PagedFlux(() -> Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(((VirtualNetworkGatewaysClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    protected Mono<VirtualNetworkGatewayInner> getInnerAsync(String groupName, String name) {
        return ((VirtualNetworkGatewaysClient)this.inner()).getByResourceGroupAsync(groupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String groupName, String name) {
        return ((VirtualNetworkGatewaysClient)this.inner()).deleteAsync(groupName, name);
    }

    protected VirtualNetworkGatewayImpl wrapModel(String name) {
        VirtualNetworkGatewayInner inner = new VirtualNetworkGatewayInner();
        return new VirtualNetworkGatewayImpl(name, inner, (NetworkManager)super.manager());
    }

    protected VirtualNetworkGatewayImpl wrapModel(VirtualNetworkGatewayInner inner) {
        if (inner == null) {
            return null;
        }
        return new VirtualNetworkGatewayImpl(inner.name(), inner, (NetworkManager)this.manager());
    }
}

