/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConfigurationType;
import java.io.IOException;
import java.util.List;

public final class NetworkManagerCommitInner
implements JsonSerializable<NetworkManagerCommitInner> {
    private String commitId;
    private List<String> targetLocations;
    private List<String> configurationIds;
    private ConfigurationType commitType;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkManagerCommitInner.class);

    public String commitId() {
        return this.commitId;
    }

    public List<String> targetLocations() {
        return this.targetLocations;
    }

    public NetworkManagerCommitInner withTargetLocations(List<String> targetLocations) {
        this.targetLocations = targetLocations;
        return this;
    }

    public List<String> configurationIds() {
        return this.configurationIds;
    }

    public NetworkManagerCommitInner withConfigurationIds(List<String> configurationIds) {
        this.configurationIds = configurationIds;
        return this;
    }

    public ConfigurationType commitType() {
        return this.commitType;
    }

    public NetworkManagerCommitInner withCommitType(ConfigurationType commitType) {
        this.commitType = commitType;
        return this;
    }

    public void validate() {
        if (this.targetLocations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetLocations in model NetworkManagerCommitInner"));
        }
        if (this.commitType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property commitType in model NetworkManagerCommitInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetLocations", this.targetLocations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("commitType", this.commitType == null ? null : this.commitType.toString());
        jsonWriter.writeArrayField("configurationIds", this.configurationIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerCommitInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerCommitInner)jsonReader.readObject(reader -> {
            NetworkManagerCommitInner deserializedNetworkManagerCommitInner = new NetworkManagerCommitInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetLocations".equals(fieldName)) {
                    List targetLocations;
                    deserializedNetworkManagerCommitInner.targetLocations = targetLocations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("commitType".equals(fieldName)) {
                    deserializedNetworkManagerCommitInner.commitType = ConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("commitId".equals(fieldName)) {
                    deserializedNetworkManagerCommitInner.commitId = reader.getString();
                    continue;
                }
                if ("configurationIds".equals(fieldName)) {
                    List configurationIds;
                    deserializedNetworkManagerCommitInner.configurationIds = configurationIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerCommitInner;
        });
    }
}

