/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.InboundSecurityRuleType;
import com.azure.resourcemanager.network.models.InboundSecurityRules;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class InboundSecurityRuleProperties
implements JsonSerializable<InboundSecurityRuleProperties> {
    private InboundSecurityRuleType ruleType;
    private List<InboundSecurityRules> rules;
    private ProvisioningState provisioningState;

    public InboundSecurityRuleType ruleType() {
        return this.ruleType;
    }

    public InboundSecurityRuleProperties withRuleType(InboundSecurityRuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    public List<InboundSecurityRules> rules() {
        return this.rules;
    }

    public InboundSecurityRuleProperties withRules(List<InboundSecurityRules> rules) {
        this.rules = rules;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static InboundSecurityRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (InboundSecurityRuleProperties)jsonReader.readObject(reader -> {
            InboundSecurityRuleProperties deserializedInboundSecurityRuleProperties = new InboundSecurityRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleType".equals(fieldName)) {
                    deserializedInboundSecurityRuleProperties.ruleType = InboundSecurityRuleType.fromString(reader.getString());
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedInboundSecurityRuleProperties.rules = rules = reader.readArray(reader1 -> InboundSecurityRules.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedInboundSecurityRuleProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInboundSecurityRuleProperties;
        });
    }
}

