/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ResourceNavigationLinkFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ResourceNavigationLink
extends SubResource {
    private ResourceNavigationLinkFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private ResourceNavigationLinkFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ResourceNavigationLink withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ResourceNavigationLink withId(String id) {
        super.withId(id);
        return this;
    }

    public String linkedResourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedResourceType();
    }

    public ResourceNavigationLink withLinkedResourceType(String linkedResourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResourceNavigationLinkFormat();
        }
        this.innerProperties().withLinkedResourceType(linkedResourceType);
        return this;
    }

    public String link() {
        return this.innerProperties() == null ? null : this.innerProperties().link();
    }

    public ResourceNavigationLink withLink(String link) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResourceNavigationLinkFormat();
        }
        this.innerProperties().withLink(link);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ResourceNavigationLink fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceNavigationLink)((Object)jsonReader.readObject(reader -> {
            ResourceNavigationLink deserializedResourceNavigationLink = new ResourceNavigationLink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceNavigationLink.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedResourceNavigationLink.innerProperties = ResourceNavigationLinkFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceNavigationLink.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedResourceNavigationLink.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceNavigationLink.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceNavigationLink;
        }));
    }
}

