/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NetworkProtocol;
import java.io.IOException;
import java.util.List;

public final class IpTraffic
implements JsonSerializable<IpTraffic> {
    private List<String> sourceIps;
    private List<String> destinationIps;
    private List<String> sourcePorts;
    private List<String> destinationPorts;
    private List<NetworkProtocol> protocols;
    private static final ClientLogger LOGGER = new ClientLogger(IpTraffic.class);

    public List<String> sourceIps() {
        return this.sourceIps;
    }

    public IpTraffic withSourceIps(List<String> sourceIps) {
        this.sourceIps = sourceIps;
        return this;
    }

    public List<String> destinationIps() {
        return this.destinationIps;
    }

    public IpTraffic withDestinationIps(List<String> destinationIps) {
        this.destinationIps = destinationIps;
        return this;
    }

    public List<String> sourcePorts() {
        return this.sourcePorts;
    }

    public IpTraffic withSourcePorts(List<String> sourcePorts) {
        this.sourcePorts = sourcePorts;
        return this;
    }

    public List<String> destinationPorts() {
        return this.destinationPorts;
    }

    public IpTraffic withDestinationPorts(List<String> destinationPorts) {
        this.destinationPorts = destinationPorts;
        return this;
    }

    public List<NetworkProtocol> protocols() {
        return this.protocols;
    }

    public IpTraffic withProtocols(List<NetworkProtocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    public void validate() {
        if (this.sourceIps() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceIps in model IpTraffic"));
        }
        if (this.destinationIps() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationIps in model IpTraffic"));
        }
        if (this.sourcePorts() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourcePorts in model IpTraffic"));
        }
        if (this.destinationPorts() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationPorts in model IpTraffic"));
        }
        if (this.protocols() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocols in model IpTraffic"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sourceIps", this.sourceIps, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationIps", this.destinationIps, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sourcePorts", this.sourcePorts, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationPorts", this.destinationPorts, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("protocols", this.protocols, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static IpTraffic fromJson(JsonReader jsonReader) throws IOException {
        return (IpTraffic)jsonReader.readObject(reader -> {
            IpTraffic deserializedIpTraffic = new IpTraffic();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceIps".equals(fieldName)) {
                    List sourceIps;
                    deserializedIpTraffic.sourceIps = sourceIps = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationIps".equals(fieldName)) {
                    List destinationIps;
                    deserializedIpTraffic.destinationIps = destinationIps = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sourcePorts".equals(fieldName)) {
                    List sourcePorts;
                    deserializedIpTraffic.sourcePorts = sourcePorts = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationPorts".equals(fieldName)) {
                    List destinationPorts;
                    deserializedIpTraffic.destinationPorts = destinationPorts = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("protocols".equals(fieldName)) {
                    List protocols;
                    deserializedIpTraffic.protocols = protocols = reader.readArray(reader1 -> NetworkProtocol.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpTraffic;
        });
    }
}

