/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.HubPublicIpAddresses;
import java.io.IOException;

public final class HubIpAddresses
implements JsonSerializable<HubIpAddresses> {
    private HubPublicIpAddresses publicIPs;
    private String privateIpAddress;

    public HubPublicIpAddresses publicIPs() {
        return this.publicIPs;
    }

    public HubIpAddresses withPublicIPs(HubPublicIpAddresses publicIPs) {
        this.publicIPs = publicIPs;
        return this;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public HubIpAddresses withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public void validate() {
        if (this.publicIPs() != null) {
            this.publicIPs().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("publicIPs", (JsonSerializable)this.publicIPs);
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        return jsonWriter.writeEndObject();
    }

    public static HubIpAddresses fromJson(JsonReader jsonReader) throws IOException {
        return (HubIpAddresses)jsonReader.readObject(reader -> {
            HubIpAddresses deserializedHubIpAddresses = new HubIpAddresses();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicIPs".equals(fieldName)) {
                    deserializedHubIpAddresses.publicIPs = HubPublicIpAddresses.fromJson(reader);
                    continue;
                }
                if ("privateIPAddress".equals(fieldName)) {
                    deserializedHubIpAddresses.privateIpAddress = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHubIpAddresses;
        });
    }
}

