/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerConnectionProperties;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import java.io.IOException;

public final class NetworkManagerConnectionInner
extends ChildResource {
    private NetworkManagerConnectionProperties innerProperties;
    private SystemData systemData;
    private String etag;
    private String type;
    private String name;
    private String id;

    private NetworkManagerConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String networkManagerId() {
        return this.innerProperties() == null ? null : this.innerProperties().networkManagerId();
    }

    public NetworkManagerConnectionInner withNetworkManagerId(String networkManagerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerConnectionProperties();
        }
        this.innerProperties().withNetworkManagerId(networkManagerId);
        return this;
    }

    public ScopeConnectionState connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public NetworkManagerConnectionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerConnectionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerConnectionInner)((Object)jsonReader.readObject(reader -> {
            NetworkManagerConnectionInner deserializedNetworkManagerConnectionInner = new NetworkManagerConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.innerProperties = NetworkManagerConnectionProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerConnectionInner;
        }));
    }
}

