/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.azure.resourcemanager.network.fluent.models.OutboundRuleInner;
import com.azure.resourcemanager.network.fluent.models.ProbeInner;
import com.azure.resourcemanager.network.models.InboundNatPool;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class LoadBalancerPropertiesFormat
implements JsonSerializable<LoadBalancerPropertiesFormat> {
    private List<FrontendIpConfigurationInner> frontendIpConfigurations;
    private List<BackendAddressPoolInner> backendAddressPools;
    private List<LoadBalancingRuleInner> loadBalancingRules;
    private List<ProbeInner> probes;
    private List<InboundNatRuleInner> inboundNatRules;
    private List<InboundNatPool> inboundNatPools;
    private List<OutboundRuleInner> outboundRules;
    private String resourceGuid;
    private ProvisioningState provisioningState;

    public List<FrontendIpConfigurationInner> frontendIpConfigurations() {
        return this.frontendIpConfigurations;
    }

    public LoadBalancerPropertiesFormat withFrontendIpConfigurations(List<FrontendIpConfigurationInner> frontendIpConfigurations) {
        this.frontendIpConfigurations = frontendIpConfigurations;
        return this;
    }

    public List<BackendAddressPoolInner> backendAddressPools() {
        return this.backendAddressPools;
    }

    public LoadBalancerPropertiesFormat withBackendAddressPools(List<BackendAddressPoolInner> backendAddressPools) {
        this.backendAddressPools = backendAddressPools;
        return this;
    }

    public List<LoadBalancingRuleInner> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public LoadBalancerPropertiesFormat withLoadBalancingRules(List<LoadBalancingRuleInner> loadBalancingRules) {
        this.loadBalancingRules = loadBalancingRules;
        return this;
    }

    public List<ProbeInner> probes() {
        return this.probes;
    }

    public LoadBalancerPropertiesFormat withProbes(List<ProbeInner> probes) {
        this.probes = probes;
        return this;
    }

    public List<InboundNatRuleInner> inboundNatRules() {
        return this.inboundNatRules;
    }

    public LoadBalancerPropertiesFormat withInboundNatRules(List<InboundNatRuleInner> inboundNatRules) {
        this.inboundNatRules = inboundNatRules;
        return this;
    }

    public List<InboundNatPool> inboundNatPools() {
        return this.inboundNatPools;
    }

    public LoadBalancerPropertiesFormat withInboundNatPools(List<InboundNatPool> inboundNatPools) {
        this.inboundNatPools = inboundNatPools;
        return this;
    }

    public List<OutboundRuleInner> outboundRules() {
        return this.outboundRules;
    }

    public LoadBalancerPropertiesFormat withOutboundRules(List<OutboundRuleInner> outboundRules) {
        this.outboundRules = outboundRules;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.frontendIpConfigurations() != null) {
            this.frontendIpConfigurations().forEach(e -> e.validate());
        }
        if (this.backendAddressPools() != null) {
            this.backendAddressPools().forEach(e -> e.validate());
        }
        if (this.loadBalancingRules() != null) {
            this.loadBalancingRules().forEach(e -> e.validate());
        }
        if (this.probes() != null) {
            this.probes().forEach(e -> e.validate());
        }
        if (this.inboundNatRules() != null) {
            this.inboundNatRules().forEach(e -> e.validate());
        }
        if (this.inboundNatPools() != null) {
            this.inboundNatPools().forEach(e -> e.validate());
        }
        if (this.outboundRules() != null) {
            this.outboundRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("frontendIPConfigurations", this.frontendIpConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("backendAddressPools", this.backendAddressPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("loadBalancingRules", this.loadBalancingRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("probes", this.probes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("inboundNatRules", this.inboundNatRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("inboundNatPools", this.inboundNatPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outboundRules", this.outboundRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static LoadBalancerPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (LoadBalancerPropertiesFormat)jsonReader.readObject(reader -> {
            LoadBalancerPropertiesFormat deserializedLoadBalancerPropertiesFormat = new LoadBalancerPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frontendIPConfigurations".equals(fieldName)) {
                    List frontendIpConfigurations;
                    deserializedLoadBalancerPropertiesFormat.frontendIpConfigurations = frontendIpConfigurations = reader.readArray(reader1 -> FrontendIpConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("backendAddressPools".equals(fieldName)) {
                    List backendAddressPools;
                    deserializedLoadBalancerPropertiesFormat.backendAddressPools = backendAddressPools = reader.readArray(reader1 -> BackendAddressPoolInner.fromJson(reader1));
                    continue;
                }
                if ("loadBalancingRules".equals(fieldName)) {
                    List loadBalancingRules;
                    deserializedLoadBalancerPropertiesFormat.loadBalancingRules = loadBalancingRules = reader.readArray(reader1 -> LoadBalancingRuleInner.fromJson(reader1));
                    continue;
                }
                if ("probes".equals(fieldName)) {
                    List probes;
                    deserializedLoadBalancerPropertiesFormat.probes = probes = reader.readArray(reader1 -> ProbeInner.fromJson(reader1));
                    continue;
                }
                if ("inboundNatRules".equals(fieldName)) {
                    List inboundNatRules;
                    deserializedLoadBalancerPropertiesFormat.inboundNatRules = inboundNatRules = reader.readArray(reader1 -> InboundNatRuleInner.fromJson(reader1));
                    continue;
                }
                if ("inboundNatPools".equals(fieldName)) {
                    List inboundNatPools;
                    deserializedLoadBalancerPropertiesFormat.inboundNatPools = inboundNatPools = reader.readArray(reader1 -> InboundNatPool.fromJson(reader1));
                    continue;
                }
                if ("outboundRules".equals(fieldName)) {
                    List outboundRules;
                    deserializedLoadBalancerPropertiesFormat.outboundRules = outboundRules = reader.readArray(reader1 -> OutboundRuleInner.fromJson(reader1));
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedLoadBalancerPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedLoadBalancerPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadBalancerPropertiesFormat;
        });
    }
}

