/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectionMonitorDestination;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpoint;
import com.azure.resourcemanager.network.models.ConnectionMonitorOutput;
import com.azure.resourcemanager.network.models.ConnectionMonitorSource;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestGroup;
import java.io.IOException;
import java.util.List;

public class ConnectionMonitorParameters
implements JsonSerializable<ConnectionMonitorParameters> {
    private ConnectionMonitorSource source;
    private ConnectionMonitorDestination destination;
    private Boolean autoStart;
    private Integer monitoringIntervalInSeconds;
    private List<ConnectionMonitorEndpoint> endpoints;
    private List<ConnectionMonitorTestConfiguration> testConfigurations;
    private List<ConnectionMonitorTestGroup> testGroups;
    private List<ConnectionMonitorOutput> outputs;
    private String notes;

    public ConnectionMonitorSource source() {
        return this.source;
    }

    public ConnectionMonitorParameters withSource(ConnectionMonitorSource source) {
        this.source = source;
        return this;
    }

    public ConnectionMonitorDestination destination() {
        return this.destination;
    }

    public ConnectionMonitorParameters withDestination(ConnectionMonitorDestination destination) {
        this.destination = destination;
        return this;
    }

    public Boolean autoStart() {
        return this.autoStart;
    }

    public ConnectionMonitorParameters withAutoStart(Boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    public Integer monitoringIntervalInSeconds() {
        return this.monitoringIntervalInSeconds;
    }

    public ConnectionMonitorParameters withMonitoringIntervalInSeconds(Integer monitoringIntervalInSeconds) {
        this.monitoringIntervalInSeconds = monitoringIntervalInSeconds;
        return this;
    }

    public List<ConnectionMonitorEndpoint> endpoints() {
        return this.endpoints;
    }

    public ConnectionMonitorParameters withEndpoints(List<ConnectionMonitorEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public List<ConnectionMonitorTestConfiguration> testConfigurations() {
        return this.testConfigurations;
    }

    public ConnectionMonitorParameters withTestConfigurations(List<ConnectionMonitorTestConfiguration> testConfigurations) {
        this.testConfigurations = testConfigurations;
        return this;
    }

    public List<ConnectionMonitorTestGroup> testGroups() {
        return this.testGroups;
    }

    public ConnectionMonitorParameters withTestGroups(List<ConnectionMonitorTestGroup> testGroups) {
        this.testGroups = testGroups;
        return this;
    }

    public List<ConnectionMonitorOutput> outputs() {
        return this.outputs;
    }

    public ConnectionMonitorParameters withOutputs(List<ConnectionMonitorOutput> outputs) {
        this.outputs = outputs;
        return this;
    }

    public String notes() {
        return this.notes;
    }

    public ConnectionMonitorParameters withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.destination() != null) {
            this.destination().validate();
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.testConfigurations() != null) {
            this.testConfigurations().forEach(e -> e.validate());
        }
        if (this.testGroups() != null) {
            this.testGroups().forEach(e -> e.validate());
        }
        if (this.outputs() != null) {
            this.outputs().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination);
        jsonWriter.writeBooleanField("autoStart", this.autoStart);
        jsonWriter.writeNumberField("monitoringIntervalInSeconds", (Number)this.monitoringIntervalInSeconds);
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("testConfigurations", this.testConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("testGroups", this.testGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("notes", this.notes);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorParameters)jsonReader.readObject(reader -> {
            ConnectionMonitorParameters deserializedConnectionMonitorParameters = new ConnectionMonitorParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedConnectionMonitorParameters.source = ConnectionMonitorSource.fromJson(reader);
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedConnectionMonitorParameters.destination = ConnectionMonitorDestination.fromJson(reader);
                    continue;
                }
                if ("autoStart".equals(fieldName)) {
                    deserializedConnectionMonitorParameters.autoStart = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("monitoringIntervalInSeconds".equals(fieldName)) {
                    deserializedConnectionMonitorParameters.monitoringIntervalInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedConnectionMonitorParameters.endpoints = endpoints = reader.readArray(reader1 -> ConnectionMonitorEndpoint.fromJson(reader1));
                    continue;
                }
                if ("testConfigurations".equals(fieldName)) {
                    List testConfigurations;
                    deserializedConnectionMonitorParameters.testConfigurations = testConfigurations = reader.readArray(reader1 -> ConnectionMonitorTestConfiguration.fromJson(reader1));
                    continue;
                }
                if ("testGroups".equals(fieldName)) {
                    List testGroups;
                    deserializedConnectionMonitorParameters.testGroups = testGroups = reader.readArray(reader1 -> ConnectionMonitorTestGroup.fromJson(reader1));
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    List outputs;
                    deserializedConnectionMonitorParameters.outputs = outputs = reader.readArray(reader1 -> ConnectionMonitorOutput.fromJson(reader1));
                    continue;
                }
                if ("notes".equals(fieldName)) {
                    deserializedConnectionMonitorParameters.notes = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorParameters;
        });
    }
}

