/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallDisabledRuleGroup;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallExclusion;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallMode;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayWebApplicationFirewallConfiguration
implements JsonSerializable<ApplicationGatewayWebApplicationFirewallConfiguration> {
    private boolean enabled;
    private ApplicationGatewayFirewallMode firewallMode;
    private String ruleSetType;
    private String ruleSetVersion;
    private List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups;
    private Boolean requestBodyCheck;
    private Integer maxRequestBodySize;
    private Integer maxRequestBodySizeInKb;
    private Integer fileUploadLimitInMb;
    private List<ApplicationGatewayFirewallExclusion> exclusions;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationGatewayWebApplicationFirewallConfiguration.class);

    public boolean enabled() {
        return this.enabled;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ApplicationGatewayFirewallMode firewallMode() {
        return this.firewallMode;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withFirewallMode(ApplicationGatewayFirewallMode firewallMode) {
        this.firewallMode = firewallMode;
        return this;
    }

    public String ruleSetType() {
        return this.ruleSetType;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    public List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups() {
        return this.disabledRuleGroups;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withDisabledRuleGroups(List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups) {
        this.disabledRuleGroups = disabledRuleGroups;
        return this;
    }

    public Boolean requestBodyCheck() {
        return this.requestBodyCheck;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withRequestBodyCheck(Boolean requestBodyCheck) {
        this.requestBodyCheck = requestBodyCheck;
        return this;
    }

    public Integer maxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withMaxRequestBodySize(Integer maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
        return this;
    }

    public Integer maxRequestBodySizeInKb() {
        return this.maxRequestBodySizeInKb;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withMaxRequestBodySizeInKb(Integer maxRequestBodySizeInKb) {
        this.maxRequestBodySizeInKb = maxRequestBodySizeInKb;
        return this;
    }

    public Integer fileUploadLimitInMb() {
        return this.fileUploadLimitInMb;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withFileUploadLimitInMb(Integer fileUploadLimitInMb) {
        this.fileUploadLimitInMb = fileUploadLimitInMb;
        return this;
    }

    public List<ApplicationGatewayFirewallExclusion> exclusions() {
        return this.exclusions;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withExclusions(List<ApplicationGatewayFirewallExclusion> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public void validate() {
        if (this.firewallMode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property firewallMode in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (this.ruleSetType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleSetType in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (this.ruleSetVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleSetVersion in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (this.disabledRuleGroups() != null) {
            this.disabledRuleGroups().forEach(e -> e.validate());
        }
        if (this.exclusions() != null) {
            this.exclusions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("firewallMode", this.firewallMode == null ? null : this.firewallMode.toString());
        jsonWriter.writeStringField("ruleSetType", this.ruleSetType);
        jsonWriter.writeStringField("ruleSetVersion", this.ruleSetVersion);
        jsonWriter.writeArrayField("disabledRuleGroups", this.disabledRuleGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("requestBodyCheck", this.requestBodyCheck);
        jsonWriter.writeNumberField("maxRequestBodySize", (Number)this.maxRequestBodySize);
        jsonWriter.writeNumberField("maxRequestBodySizeInKb", (Number)this.maxRequestBodySizeInKb);
        jsonWriter.writeNumberField("fileUploadLimitInMb", (Number)this.fileUploadLimitInMb);
        jsonWriter.writeArrayField("exclusions", this.exclusions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayWebApplicationFirewallConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayWebApplicationFirewallConfiguration)jsonReader.readObject(reader -> {
            ApplicationGatewayWebApplicationFirewallConfiguration deserializedApplicationGatewayWebApplicationFirewallConfiguration = new ApplicationGatewayWebApplicationFirewallConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.enabled = reader.getBoolean();
                    continue;
                }
                if ("firewallMode".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.firewallMode = ApplicationGatewayFirewallMode.fromString(reader.getString());
                    continue;
                }
                if ("ruleSetType".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.ruleSetType = reader.getString();
                    continue;
                }
                if ("ruleSetVersion".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.ruleSetVersion = reader.getString();
                    continue;
                }
                if ("disabledRuleGroups".equals(fieldName)) {
                    List disabledRuleGroups;
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.disabledRuleGroups = disabledRuleGroups = reader.readArray(reader1 -> ApplicationGatewayFirewallDisabledRuleGroup.fromJson(reader1));
                    continue;
                }
                if ("requestBodyCheck".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.requestBodyCheck = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxRequestBodySize".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.maxRequestBodySize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxRequestBodySizeInKb".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.maxRequestBodySizeInKb = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fileUploadLimitInMb".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.fileUploadLimitInMb = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("exclusions".equals(fieldName)) {
                    List exclusions;
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.exclusions = exclusions = reader.readArray(reader1 -> ApplicationGatewayFirewallExclusion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayWebApplicationFirewallConfiguration;
        });
    }
}

