/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyRule;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleNetworkProtocol;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleType;
import java.io.IOException;
import java.util.List;

public final class NatRule
extends FirewallPolicyRule {
    private FirewallPolicyRuleType ruleType = FirewallPolicyRuleType.NAT_RULE;
    private List<FirewallPolicyRuleNetworkProtocol> ipProtocols;
    private List<String> sourceAddresses;
    private List<String> destinationAddresses;
    private List<String> destinationPorts;
    private String translatedAddress;
    private String translatedPort;
    private List<String> sourceIpGroups;
    private String translatedFqdn;

    @Override
    public FirewallPolicyRuleType ruleType() {
        return this.ruleType;
    }

    public List<FirewallPolicyRuleNetworkProtocol> ipProtocols() {
        return this.ipProtocols;
    }

    public NatRule withIpProtocols(List<FirewallPolicyRuleNetworkProtocol> ipProtocols) {
        this.ipProtocols = ipProtocols;
        return this;
    }

    public List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    public NatRule withSourceAddresses(List<String> sourceAddresses) {
        this.sourceAddresses = sourceAddresses;
        return this;
    }

    public List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    public NatRule withDestinationAddresses(List<String> destinationAddresses) {
        this.destinationAddresses = destinationAddresses;
        return this;
    }

    public List<String> destinationPorts() {
        return this.destinationPorts;
    }

    public NatRule withDestinationPorts(List<String> destinationPorts) {
        this.destinationPorts = destinationPorts;
        return this;
    }

    public String translatedAddress() {
        return this.translatedAddress;
    }

    public NatRule withTranslatedAddress(String translatedAddress) {
        this.translatedAddress = translatedAddress;
        return this;
    }

    public String translatedPort() {
        return this.translatedPort;
    }

    public NatRule withTranslatedPort(String translatedPort) {
        this.translatedPort = translatedPort;
        return this;
    }

    public List<String> sourceIpGroups() {
        return this.sourceIpGroups;
    }

    public NatRule withSourceIpGroups(List<String> sourceIpGroups) {
        this.sourceIpGroups = sourceIpGroups;
        return this;
    }

    public String translatedFqdn() {
        return this.translatedFqdn;
    }

    public NatRule withTranslatedFqdn(String translatedFqdn) {
        this.translatedFqdn = translatedFqdn;
        return this;
    }

    @Override
    public NatRule withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public NatRule withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeArrayField("ipProtocols", this.ipProtocols, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("sourceAddresses", this.sourceAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationAddresses", this.destinationAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationPorts", this.destinationPorts, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("translatedAddress", this.translatedAddress);
        jsonWriter.writeStringField("translatedPort", this.translatedPort);
        jsonWriter.writeArrayField("sourceIpGroups", this.sourceIpGroups, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("translatedFqdn", this.translatedFqdn);
        return jsonWriter.writeEndObject();
    }

    public static NatRule fromJson(JsonReader jsonReader) throws IOException {
        return (NatRule)jsonReader.readObject(reader -> {
            NatRule deserializedNatRule = new NatRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNatRule.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNatRule.withDescription(reader.getString());
                    continue;
                }
                if ("ruleType".equals(fieldName)) {
                    deserializedNatRule.ruleType = FirewallPolicyRuleType.fromString(reader.getString());
                    continue;
                }
                if ("ipProtocols".equals(fieldName)) {
                    List ipProtocols;
                    deserializedNatRule.ipProtocols = ipProtocols = reader.readArray(reader1 -> FirewallPolicyRuleNetworkProtocol.fromString(reader1.getString()));
                    continue;
                }
                if ("sourceAddresses".equals(fieldName)) {
                    List sourceAddresses;
                    deserializedNatRule.sourceAddresses = sourceAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationAddresses".equals(fieldName)) {
                    List destinationAddresses;
                    deserializedNatRule.destinationAddresses = destinationAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationPorts".equals(fieldName)) {
                    List destinationPorts;
                    deserializedNatRule.destinationPorts = destinationPorts = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("translatedAddress".equals(fieldName)) {
                    deserializedNatRule.translatedAddress = reader.getString();
                    continue;
                }
                if ("translatedPort".equals(fieldName)) {
                    deserializedNatRule.translatedPort = reader.getString();
                    continue;
                }
                if ("sourceIpGroups".equals(fieldName)) {
                    List sourceIpGroups;
                    deserializedNatRule.sourceIpGroups = sourceIpGroups = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("translatedFqdn".equals(fieldName)) {
                    deserializedNatRule.translatedFqdn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNatRule;
        });
    }
}

