/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.models.HasPrivateIpAddress;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerFrontend;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasSubnet;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.Settable;
import java.util.Set;

public interface LoadBalancerPrivateFrontend
extends LoadBalancerFrontend,
HasPrivateIpAddress,
HasSubnet {
    public Subnet getSubnet();

    public Set<AvailabilityZoneId> availabilityZones();

    public static interface UpdateDefinition<ParentT>
    extends UpdateDefinitionStages.Blank<ParentT>,
    UpdateDefinitionStages.WithAttach<ParentT>,
    UpdateDefinitionStages.WithSubnet<ParentT> {
    }

    public static interface UpdateDefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InUpdateAlt<ParentT>,
        HasPrivateIpAddress.UpdateDefinitionStages.WithPrivateIPAddress<WithAttach<ParentT>>,
        WithAvailabilityZone<ParentT> {
        }

        public static interface WithAvailabilityZone<ParentT> {
            public WithAttach<ParentT> withAvailabilityZone(AvailabilityZoneId var1);
        }

        public static interface WithSubnet<ParentT> {
            public WithAttach<ParentT> withExistingSubnet(Network var1, String var2);
        }

        public static interface Blank<ParentT>
        extends WithSubnet<ParentT> {
        }
    }

    public static interface Update
    extends Settable<LoadBalancer.Update>,
    UpdateStages.WithSubnet,
    HasPrivateIpAddress.UpdateStages.WithPrivateIPAddress<Update> {
    }

    public static interface UpdateStages {

        public static interface WithSubnet {
            public Update withExistingSubnet(Network var1, String var2);
        }
    }

    public static interface Definition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithAttach<ParentT>,
    DefinitionStages.WithSubnet<ParentT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InDefinitionAlt<ParentT>,
        HasPrivateIpAddress.DefinitionStages.WithPrivateIPAddress<WithAttach<ParentT>>,
        WithAvailabilityZone<ParentT> {
        }

        public static interface WithAvailabilityZone<ParentT> {
            public WithAttach<ParentT> withAvailabilityZone(AvailabilityZoneId var1);
        }

        public static interface WithSubnet<ParentT>
        extends HasSubnet.DefinitionStages.WithSubnet<WithAttach<ParentT>> {
            public WithAttach<ParentT> withExistingSubnet(Network var1, String var2);
        }

        public static interface Blank<ParentT>
        extends WithSubnet<ParentT> {
        }
    }
}

