/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AzureFirewallNetworkRuleProtocol;
import com.azure.resourcemanager.network.models.AzureFirewallPacketCaptureFlags;
import com.azure.resourcemanager.network.models.AzureFirewallPacketCaptureRule;
import java.io.IOException;
import java.util.List;

public final class FirewallPacketCaptureParameters
implements JsonSerializable<FirewallPacketCaptureParameters> {
    private Integer durationInSeconds;
    private Integer numberOfPacketsToCapture;
    private String sasUrl;
    private String fileName;
    private AzureFirewallNetworkRuleProtocol protocol;
    private List<AzureFirewallPacketCaptureFlags> flags;
    private List<AzureFirewallPacketCaptureRule> filters;

    public Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public FirewallPacketCaptureParameters withDurationInSeconds(Integer durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
        return this;
    }

    public Integer numberOfPacketsToCapture() {
        return this.numberOfPacketsToCapture;
    }

    public FirewallPacketCaptureParameters withNumberOfPacketsToCapture(Integer numberOfPacketsToCapture) {
        this.numberOfPacketsToCapture = numberOfPacketsToCapture;
        return this;
    }

    public String sasUrl() {
        return this.sasUrl;
    }

    public FirewallPacketCaptureParameters withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    public String fileName() {
        return this.fileName;
    }

    public FirewallPacketCaptureParameters withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public AzureFirewallNetworkRuleProtocol protocol() {
        return this.protocol;
    }

    public FirewallPacketCaptureParameters withProtocol(AzureFirewallNetworkRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public List<AzureFirewallPacketCaptureFlags> flags() {
        return this.flags;
    }

    public FirewallPacketCaptureParameters withFlags(List<AzureFirewallPacketCaptureFlags> flags) {
        this.flags = flags;
        return this;
    }

    public List<AzureFirewallPacketCaptureRule> filters() {
        return this.filters;
    }

    public FirewallPacketCaptureParameters withFilters(List<AzureFirewallPacketCaptureRule> filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.flags() != null) {
            this.flags().forEach(e -> e.validate());
        }
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("durationInSeconds", (Number)this.durationInSeconds);
        jsonWriter.writeNumberField("numberOfPacketsToCapture", (Number)this.numberOfPacketsToCapture);
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeArrayField("flags", this.flags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FirewallPacketCaptureParameters fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallPacketCaptureParameters)jsonReader.readObject(reader -> {
            FirewallPacketCaptureParameters deserializedFirewallPacketCaptureParameters = new FirewallPacketCaptureParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("durationInSeconds".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.durationInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfPacketsToCapture".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.numberOfPacketsToCapture = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sasUrl".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.sasUrl = reader.getString();
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.fileName = reader.getString();
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.protocol = AzureFirewallNetworkRuleProtocol.fromString(reader.getString());
                    continue;
                }
                if ("flags".equals(fieldName)) {
                    List flags;
                    deserializedFirewallPacketCaptureParameters.flags = flags = reader.readArray(reader1 -> AzureFirewallPacketCaptureFlags.fromJson(reader1));
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedFirewallPacketCaptureParameters.filters = filters = reader.readArray(reader1 -> AzureFirewallPacketCaptureRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallPacketCaptureParameters;
        });
    }
}

