/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AzureFirewallNatRuleCollectionProperties;
import com.azure.resourcemanager.network.models.AzureFirewallNatRCAction;
import com.azure.resourcemanager.network.models.AzureFirewallNatRule;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class AzureFirewallNatRuleCollection
extends SubResource {
    private AzureFirewallNatRuleCollectionProperties innerProperties;
    private String name;
    private String etag;

    private AzureFirewallNatRuleCollectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public AzureFirewallNatRuleCollection withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public AzureFirewallNatRuleCollection withId(String id) {
        super.withId(id);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public AzureFirewallNatRuleCollection withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallNatRuleCollectionProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public AzureFirewallNatRCAction action() {
        return this.innerProperties() == null ? null : this.innerProperties().action();
    }

    public AzureFirewallNatRuleCollection withAction(AzureFirewallNatRCAction action) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallNatRuleCollectionProperties();
        }
        this.innerProperties().withAction(action);
        return this;
    }

    public List<AzureFirewallNatRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    public AzureFirewallNatRuleCollection withRules(List<AzureFirewallNatRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallNatRuleCollectionProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static AzureFirewallNatRuleCollection fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFirewallNatRuleCollection)((Object)jsonReader.readObject(reader -> {
            AzureFirewallNatRuleCollection deserializedAzureFirewallNatRuleCollection = new AzureFirewallNatRuleCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAzureFirewallNatRuleCollection.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAzureFirewallNatRuleCollection.innerProperties = AzureFirewallNatRuleCollectionProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAzureFirewallNatRuleCollection.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedAzureFirewallNatRuleCollection.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirewallNatRuleCollection;
        }));
    }
}

