/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyLogAnalyticsResources;
import java.io.IOException;

public final class FirewallPolicyInsights
implements JsonSerializable<FirewallPolicyInsights> {
    private Boolean isEnabled;
    private Integer retentionDays;
    private FirewallPolicyLogAnalyticsResources logAnalyticsResources;

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public FirewallPolicyInsights withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public Integer retentionDays() {
        return this.retentionDays;
    }

    public FirewallPolicyInsights withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    public FirewallPolicyLogAnalyticsResources logAnalyticsResources() {
        return this.logAnalyticsResources;
    }

    public FirewallPolicyInsights withLogAnalyticsResources(FirewallPolicyLogAnalyticsResources logAnalyticsResources) {
        this.logAnalyticsResources = logAnalyticsResources;
        return this;
    }

    public void validate() {
        if (this.logAnalyticsResources() != null) {
            this.logAnalyticsResources().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeNumberField("retentionDays", (Number)this.retentionDays);
        jsonWriter.writeJsonField("logAnalyticsResources", (JsonSerializable)this.logAnalyticsResources);
        return jsonWriter.writeEndObject();
    }

    public static FirewallPolicyInsights fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallPolicyInsights)jsonReader.readObject(reader -> {
            FirewallPolicyInsights deserializedFirewallPolicyInsights = new FirewallPolicyInsights();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isEnabled".equals(fieldName)) {
                    deserializedFirewallPolicyInsights.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("retentionDays".equals(fieldName)) {
                    deserializedFirewallPolicyInsights.retentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("logAnalyticsResources".equals(fieldName)) {
                    deserializedFirewallPolicyInsights.logAnalyticsResources = FirewallPolicyLogAnalyticsResources.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallPolicyInsights;
        });
    }
}

