/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NspLinkProvisioningState;
import com.azure.resourcemanager.network.models.NspLinkStatus;
import java.io.IOException;
import java.util.List;

public final class NspLinkProperties
implements JsonSerializable<NspLinkProperties> {
    private NspLinkProvisioningState provisioningState;
    private String autoApprovedRemotePerimeterResourceId;
    private String remotePerimeterGuid;
    private String remotePerimeterLocation;
    private List<String> localInboundProfiles;
    private List<String> localOutboundProfiles;
    private List<String> remoteInboundProfiles;
    private List<String> remoteOutboundProfiles;
    private String description;
    private NspLinkStatus status;

    public NspLinkProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String autoApprovedRemotePerimeterResourceId() {
        return this.autoApprovedRemotePerimeterResourceId;
    }

    public NspLinkProperties withAutoApprovedRemotePerimeterResourceId(String autoApprovedRemotePerimeterResourceId) {
        this.autoApprovedRemotePerimeterResourceId = autoApprovedRemotePerimeterResourceId;
        return this;
    }

    public String remotePerimeterGuid() {
        return this.remotePerimeterGuid;
    }

    public String remotePerimeterLocation() {
        return this.remotePerimeterLocation;
    }

    public List<String> localInboundProfiles() {
        return this.localInboundProfiles;
    }

    public NspLinkProperties withLocalInboundProfiles(List<String> localInboundProfiles) {
        this.localInboundProfiles = localInboundProfiles;
        return this;
    }

    public List<String> localOutboundProfiles() {
        return this.localOutboundProfiles;
    }

    public List<String> remoteInboundProfiles() {
        return this.remoteInboundProfiles;
    }

    public NspLinkProperties withRemoteInboundProfiles(List<String> remoteInboundProfiles) {
        this.remoteInboundProfiles = remoteInboundProfiles;
        return this;
    }

    public List<String> remoteOutboundProfiles() {
        return this.remoteOutboundProfiles;
    }

    public String description() {
        return this.description;
    }

    public NspLinkProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public NspLinkStatus status() {
        return this.status;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoApprovedRemotePerimeterResourceId", this.autoApprovedRemotePerimeterResourceId);
        jsonWriter.writeArrayField("localInboundProfiles", this.localInboundProfiles, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("remoteInboundProfiles", this.remoteInboundProfiles, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static NspLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NspLinkProperties)jsonReader.readObject(reader -> {
            NspLinkProperties deserializedNspLinkProperties = new NspLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNspLinkProperties.provisioningState = NspLinkProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("autoApprovedRemotePerimeterResourceId".equals(fieldName)) {
                    deserializedNspLinkProperties.autoApprovedRemotePerimeterResourceId = reader.getString();
                    continue;
                }
                if ("remotePerimeterGuid".equals(fieldName)) {
                    deserializedNspLinkProperties.remotePerimeterGuid = reader.getString();
                    continue;
                }
                if ("remotePerimeterLocation".equals(fieldName)) {
                    deserializedNspLinkProperties.remotePerimeterLocation = reader.getString();
                    continue;
                }
                if ("localInboundProfiles".equals(fieldName)) {
                    List localInboundProfiles;
                    deserializedNspLinkProperties.localInboundProfiles = localInboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("localOutboundProfiles".equals(fieldName)) {
                    List localOutboundProfiles;
                    deserializedNspLinkProperties.localOutboundProfiles = localOutboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("remoteInboundProfiles".equals(fieldName)) {
                    List remoteInboundProfiles;
                    deserializedNspLinkProperties.remoteInboundProfiles = remoteInboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("remoteOutboundProfiles".equals(fieldName)) {
                    List remoteOutboundProfiles;
                    deserializedNspLinkProperties.remoteOutboundProfiles = remoteOutboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNspLinkProperties.description = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedNspLinkProperties.status = NspLinkStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspLinkProperties;
        });
    }
}

