/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import java.io.IOException;
import java.util.List;

public final class SecurityRuleListResult
implements JsonSerializable<SecurityRuleListResult> {
    private List<SecurityRuleInner> value;
    private String nextLink;

    public List<SecurityRuleInner> value() {
        return this.value;
    }

    public SecurityRuleListResult withValue(List<SecurityRuleInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public SecurityRuleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SecurityRuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityRuleListResult)jsonReader.readObject(reader -> {
            SecurityRuleListResult deserializedSecurityRuleListResult = new SecurityRuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSecurityRuleListResult.value = value = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSecurityRuleListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityRuleListResult;
        });
    }
}

