/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DestinationPortBehavior;
import java.io.IOException;

public final class ConnectionMonitorTcpConfiguration
implements JsonSerializable<ConnectionMonitorTcpConfiguration> {
    private Integer port;
    private Boolean disableTraceRoute;
    private DestinationPortBehavior destinationPortBehavior;

    public Integer port() {
        return this.port;
    }

    public ConnectionMonitorTcpConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean disableTraceRoute() {
        return this.disableTraceRoute;
    }

    public ConnectionMonitorTcpConfiguration withDisableTraceRoute(Boolean disableTraceRoute) {
        this.disableTraceRoute = disableTraceRoute;
        return this;
    }

    public DestinationPortBehavior destinationPortBehavior() {
        return this.destinationPortBehavior;
    }

    public ConnectionMonitorTcpConfiguration withDestinationPortBehavior(DestinationPortBehavior destinationPortBehavior) {
        this.destinationPortBehavior = destinationPortBehavior;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeBooleanField("disableTraceRoute", this.disableTraceRoute);
        jsonWriter.writeStringField("destinationPortBehavior", this.destinationPortBehavior == null ? null : this.destinationPortBehavior.toString());
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorTcpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorTcpConfiguration)jsonReader.readObject(reader -> {
            ConnectionMonitorTcpConfiguration deserializedConnectionMonitorTcpConfiguration = new ConnectionMonitorTcpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("port".equals(fieldName)) {
                    deserializedConnectionMonitorTcpConfiguration.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("disableTraceRoute".equals(fieldName)) {
                    deserializedConnectionMonitorTcpConfiguration.disableTraceRoute = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("destinationPortBehavior".equals(fieldName)) {
                    deserializedConnectionMonitorTcpConfiguration.destinationPortBehavior = DestinationPortBehavior.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorTcpConfiguration;
        });
    }
}

