/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.SingleQueryResult;
import java.io.IOException;
import java.util.List;

public final class QueryResultsInner
implements JsonSerializable<QueryResultsInner> {
    private Long matchingRecordsCount;
    private List<SingleQueryResult> signatures;

    public Long matchingRecordsCount() {
        return this.matchingRecordsCount;
    }

    public QueryResultsInner withMatchingRecordsCount(Long matchingRecordsCount) {
        this.matchingRecordsCount = matchingRecordsCount;
        return this;
    }

    public List<SingleQueryResult> signatures() {
        return this.signatures;
    }

    public QueryResultsInner withSignatures(List<SingleQueryResult> signatures) {
        this.signatures = signatures;
        return this;
    }

    public void validate() {
        if (this.signatures() != null) {
            this.signatures().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("matchingRecordsCount", (Number)this.matchingRecordsCount);
        jsonWriter.writeArrayField("signatures", this.signatures, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static QueryResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (QueryResultsInner)jsonReader.readObject(reader -> {
            QueryResultsInner deserializedQueryResultsInner = new QueryResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("matchingRecordsCount".equals(fieldName)) {
                    deserializedQueryResultsInner.matchingRecordsCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("signatures".equals(fieldName)) {
                    List signatures;
                    deserializedQueryResultsInner.signatures = signatures = reader.readArray(reader1 -> SingleQueryResult.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryResultsInner;
        });
    }
}

