/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CommonTrackedResource;
import com.azure.resourcemanager.network.models.IpamPoolProperties;
import java.io.IOException;
import java.util.Map;

public final class IpamPoolInner
extends CommonTrackedResource {
    private IpamPoolProperties properties;
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(IpamPoolInner.class);

    public IpamPoolProperties properties() {
        return this.properties;
    }

    public IpamPoolInner withProperties(IpamPoolProperties properties) {
        this.properties = properties;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public IpamPoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public IpamPoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model IpamPoolInner"));
        }
        this.properties().validate();
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model IpamPoolInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static IpamPoolInner fromJson(JsonReader jsonReader) throws IOException {
        return (IpamPoolInner)((Object)jsonReader.readObject(reader -> {
            IpamPoolInner deserializedIpamPoolInner = new IpamPoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIpamPoolInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIpamPoolInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIpamPoolInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIpamPoolInner.withLocation(reader.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedIpamPoolInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIpamPoolInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIpamPoolInner.properties = IpamPoolProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedIpamPoolInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpamPoolInner;
        }));
    }
}

