/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class HubIpConfigurationPropertiesFormatInner
implements JsonSerializable<HubIpConfigurationPropertiesFormatInner> {
    private String privateIpAddress;
    private IpAllocationMethod privateIpAllocationMethod;
    private SubnetInner subnet;
    private PublicIpAddressInner publicIpAddress;
    private ProvisioningState provisioningState;

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public HubIpConfigurationPropertiesFormatInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public HubIpConfigurationPropertiesFormatInner withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public SubnetInner subnet() {
        return this.subnet;
    }

    public HubIpConfigurationPropertiesFormatInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    public PublicIpAddressInner publicIpAddress() {
        return this.publicIpAddress;
    }

    public HubIpConfigurationPropertiesFormatInner withPublicIpAddress(PublicIpAddressInner publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.publicIpAddress() != null) {
            this.publicIpAddress().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod", this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", (JsonSerializable)this.publicIpAddress);
        return jsonWriter.writeEndObject();
    }

    public static HubIpConfigurationPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return (HubIpConfigurationPropertiesFormatInner)jsonReader.readObject(reader -> {
            HubIpConfigurationPropertiesFormatInner deserializedHubIpConfigurationPropertiesFormatInner = new HubIpConfigurationPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateIPAddress".equals(fieldName)) {
                    deserializedHubIpConfigurationPropertiesFormatInner.privateIpAddress = reader.getString();
                    continue;
                }
                if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedHubIpConfigurationPropertiesFormatInner.privateIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedHubIpConfigurationPropertiesFormatInner.subnet = SubnetInner.fromJson(reader);
                    continue;
                }
                if ("publicIPAddress".equals(fieldName)) {
                    deserializedHubIpConfigurationPropertiesFormatInner.publicIpAddress = PublicIpAddressInner.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedHubIpConfigurationPropertiesFormatInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHubIpConfigurationPropertiesFormatInner;
        });
    }
}

