/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRouteFailoverRedundantRoute;
import com.azure.resourcemanager.network.models.FailoverConnectionDetails;
import com.azure.resourcemanager.network.models.FailoverTestStatusForSingleTest;
import java.io.IOException;
import java.util.List;

public final class ExpressRouteFailoverSingleTestDetailsInner
implements JsonSerializable<ExpressRouteFailoverSingleTestDetailsInner> {
    private String peeringLocation;
    private FailoverTestStatusForSingleTest status;
    private String startTimeUtc;
    private String endTimeUtc;
    private List<ExpressRouteFailoverRedundantRoute> redundantRoutes;
    private List<String> nonRedundantRoutes;
    private Boolean wasSimulationSuccessful;
    private List<FailoverConnectionDetails> failoverConnectionDetails;

    public String peeringLocation() {
        return this.peeringLocation;
    }

    public ExpressRouteFailoverSingleTestDetailsInner withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    public FailoverTestStatusForSingleTest status() {
        return this.status;
    }

    public ExpressRouteFailoverSingleTestDetailsInner withStatus(FailoverTestStatusForSingleTest status) {
        this.status = status;
        return this;
    }

    public String startTimeUtc() {
        return this.startTimeUtc;
    }

    public ExpressRouteFailoverSingleTestDetailsInner withStartTimeUtc(String startTimeUtc) {
        this.startTimeUtc = startTimeUtc;
        return this;
    }

    public String endTimeUtc() {
        return this.endTimeUtc;
    }

    public ExpressRouteFailoverSingleTestDetailsInner withEndTimeUtc(String endTimeUtc) {
        this.endTimeUtc = endTimeUtc;
        return this;
    }

    public List<ExpressRouteFailoverRedundantRoute> redundantRoutes() {
        return this.redundantRoutes;
    }

    public ExpressRouteFailoverSingleTestDetailsInner withRedundantRoutes(List<ExpressRouteFailoverRedundantRoute> redundantRoutes) {
        this.redundantRoutes = redundantRoutes;
        return this;
    }

    public List<String> nonRedundantRoutes() {
        return this.nonRedundantRoutes;
    }

    public ExpressRouteFailoverSingleTestDetailsInner withNonRedundantRoutes(List<String> nonRedundantRoutes) {
        this.nonRedundantRoutes = nonRedundantRoutes;
        return this;
    }

    public Boolean wasSimulationSuccessful() {
        return this.wasSimulationSuccessful;
    }

    public ExpressRouteFailoverSingleTestDetailsInner withWasSimulationSuccessful(Boolean wasSimulationSuccessful) {
        this.wasSimulationSuccessful = wasSimulationSuccessful;
        return this;
    }

    public List<FailoverConnectionDetails> failoverConnectionDetails() {
        return this.failoverConnectionDetails;
    }

    public ExpressRouteFailoverSingleTestDetailsInner withFailoverConnectionDetails(List<FailoverConnectionDetails> failoverConnectionDetails) {
        this.failoverConnectionDetails = failoverConnectionDetails;
        return this;
    }

    public void validate() {
        if (this.redundantRoutes() != null) {
            this.redundantRoutes().forEach(e -> e.validate());
        }
        if (this.failoverConnectionDetails() != null) {
            this.failoverConnectionDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peeringLocation", this.peeringLocation);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startTimeUtc", this.startTimeUtc);
        jsonWriter.writeStringField("endTimeUtc", this.endTimeUtc);
        jsonWriter.writeArrayField("redundantRoutes", this.redundantRoutes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("nonRedundantRoutes", this.nonRedundantRoutes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("wasSimulationSuccessful", this.wasSimulationSuccessful);
        jsonWriter.writeArrayField("failoverConnectionDetails", this.failoverConnectionDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteFailoverSingleTestDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteFailoverSingleTestDetailsInner)jsonReader.readObject(reader -> {
            ExpressRouteFailoverSingleTestDetailsInner deserializedExpressRouteFailoverSingleTestDetailsInner = new ExpressRouteFailoverSingleTestDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.peeringLocation = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.status = FailoverTestStatusForSingleTest.fromString(reader.getString());
                    continue;
                }
                if ("startTimeUtc".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.startTimeUtc = reader.getString();
                    continue;
                }
                if ("endTimeUtc".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.endTimeUtc = reader.getString();
                    continue;
                }
                if ("redundantRoutes".equals(fieldName)) {
                    List redundantRoutes;
                    deserializedExpressRouteFailoverSingleTestDetailsInner.redundantRoutes = redundantRoutes = reader.readArray(reader1 -> ExpressRouteFailoverRedundantRoute.fromJson(reader1));
                    continue;
                }
                if ("nonRedundantRoutes".equals(fieldName)) {
                    List nonRedundantRoutes;
                    deserializedExpressRouteFailoverSingleTestDetailsInner.nonRedundantRoutes = nonRedundantRoutes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("wasSimulationSuccessful".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.wasSimulationSuccessful = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("failoverConnectionDetails".equals(fieldName)) {
                    List failoverConnectionDetails;
                    deserializedExpressRouteFailoverSingleTestDetailsInner.failoverConnectionDetails = failoverConnectionDetails = reader.readArray(reader1 -> FailoverConnectionDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteFailoverSingleTestDetailsInner;
        });
    }
}

