/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.BgpCommunity;
import java.io.IOException;
import java.util.List;

public final class BgpServiceCommunityPropertiesFormat
implements JsonSerializable<BgpServiceCommunityPropertiesFormat> {
    private String serviceName;
    private List<BgpCommunity> bgpCommunities;

    public String serviceName() {
        return this.serviceName;
    }

    public BgpServiceCommunityPropertiesFormat withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public List<BgpCommunity> bgpCommunities() {
        return this.bgpCommunities;
    }

    public BgpServiceCommunityPropertiesFormat withBgpCommunities(List<BgpCommunity> bgpCommunities) {
        this.bgpCommunities = bgpCommunities;
        return this;
    }

    public void validate() {
        if (this.bgpCommunities() != null) {
            this.bgpCommunities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeArrayField("bgpCommunities", this.bgpCommunities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BgpServiceCommunityPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (BgpServiceCommunityPropertiesFormat)jsonReader.readObject(reader -> {
            BgpServiceCommunityPropertiesFormat deserializedBgpServiceCommunityPropertiesFormat = new BgpServiceCommunityPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceName".equals(fieldName)) {
                    deserializedBgpServiceCommunityPropertiesFormat.serviceName = reader.getString();
                    continue;
                }
                if ("bgpCommunities".equals(fieldName)) {
                    List bgpCommunities;
                    deserializedBgpServiceCommunityPropertiesFormat.bgpCommunities = bgpCommunities = reader.readArray(reader1 -> BgpCommunity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpServiceCommunityPropertiesFormat;
        });
    }
}

