/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayCustomError;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayHttpListenerPropertiesFormat
implements JsonSerializable<ApplicationGatewayHttpListenerPropertiesFormat> {
    private SubResource frontendIpConfiguration;
    private SubResource frontendPort;
    private ApplicationGatewayProtocol protocol;
    private String hostname;
    private SubResource sslCertificate;
    private SubResource sslProfile;
    private Boolean requireServerNameIndication;
    private ProvisioningState provisioningState;
    private List<ApplicationGatewayCustomError> customErrorConfigurations;
    private SubResource firewallPolicy;
    private List<String> hostNames;

    public SubResource frontendIpConfiguration() {
        return this.frontendIpConfiguration;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        this.frontendIpConfiguration = frontendIpConfiguration;
        return this;
    }

    public SubResource frontendPort() {
        return this.frontendPort;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withFrontendPort(SubResource frontendPort) {
        this.frontendPort = frontendPort;
        return this;
    }

    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public SubResource sslCertificate() {
        return this.sslCertificate;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withSslCertificate(SubResource sslCertificate) {
        this.sslCertificate = sslCertificate;
        return this;
    }

    public SubResource sslProfile() {
        return this.sslProfile;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withSslProfile(SubResource sslProfile) {
        this.sslProfile = sslProfile;
        return this;
    }

    public Boolean requireServerNameIndication() {
        return this.requireServerNameIndication;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withRequireServerNameIndication(Boolean requireServerNameIndication) {
        this.requireServerNameIndication = requireServerNameIndication;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ApplicationGatewayCustomError> customErrorConfigurations() {
        return this.customErrorConfigurations;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withCustomErrorConfigurations(List<ApplicationGatewayCustomError> customErrorConfigurations) {
        this.customErrorConfigurations = customErrorConfigurations;
        return this;
    }

    public SubResource firewallPolicy() {
        return this.firewallPolicy;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withFirewallPolicy(SubResource firewallPolicy) {
        this.firewallPolicy = firewallPolicy;
        return this;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public ApplicationGatewayHttpListenerPropertiesFormat withHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public void validate() {
        if (this.customErrorConfigurations() != null) {
            this.customErrorConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("frontendIPConfiguration", (JsonSerializable)this.frontendIpConfiguration);
        jsonWriter.writeJsonField("frontendPort", (JsonSerializable)this.frontendPort);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeJsonField("sslCertificate", (JsonSerializable)this.sslCertificate);
        jsonWriter.writeJsonField("sslProfile", (JsonSerializable)this.sslProfile);
        jsonWriter.writeBooleanField("requireServerNameIndication", this.requireServerNameIndication);
        jsonWriter.writeArrayField("customErrorConfigurations", this.customErrorConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("firewallPolicy", (JsonSerializable)this.firewallPolicy);
        jsonWriter.writeArrayField("hostNames", this.hostNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayHttpListenerPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayHttpListenerPropertiesFormat)jsonReader.readObject(reader -> {
            ApplicationGatewayHttpListenerPropertiesFormat deserializedApplicationGatewayHttpListenerPropertiesFormat = new ApplicationGatewayHttpListenerPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frontendIPConfiguration".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.frontendIpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("frontendPort".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.frontendPort = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.protocol = ApplicationGatewayProtocol.fromString(reader.getString());
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.hostname = reader.getString();
                    continue;
                }
                if ("sslCertificate".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.sslCertificate = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("sslProfile".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.sslProfile = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("requireServerNameIndication".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.requireServerNameIndication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("customErrorConfigurations".equals(fieldName)) {
                    List customErrorConfigurations;
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.customErrorConfigurations = customErrorConfigurations = reader.readArray(reader1 -> ApplicationGatewayCustomError.fromJson(reader1));
                    continue;
                }
                if ("firewallPolicy".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.firewallPolicy = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("hostNames".equals(fieldName)) {
                    List hostNames;
                    deserializedApplicationGatewayHttpListenerPropertiesFormat.hostNames = hostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayHttpListenerPropertiesFormat;
        });
    }
}

