/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddress;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayBackendAddressPoolPropertiesFormat
implements JsonSerializable<ApplicationGatewayBackendAddressPoolPropertiesFormat> {
    private List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations;
    private List<ApplicationGatewayBackendAddress> backendAddresses;
    private ProvisioningState provisioningState;

    public List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations() {
        return this.backendIpConfigurations;
    }

    public List<ApplicationGatewayBackendAddress> backendAddresses() {
        return this.backendAddresses;
    }

    public ApplicationGatewayBackendAddressPoolPropertiesFormat withBackendAddresses(List<ApplicationGatewayBackendAddress> backendAddresses) {
        this.backendAddresses = backendAddresses;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.backendIpConfigurations() != null) {
            this.backendIpConfigurations().forEach(e -> e.validate());
        }
        if (this.backendAddresses() != null) {
            this.backendAddresses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("backendAddresses", this.backendAddresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayBackendAddressPoolPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayBackendAddressPoolPropertiesFormat)jsonReader.readObject(reader -> {
            ApplicationGatewayBackendAddressPoolPropertiesFormat deserializedApplicationGatewayBackendAddressPoolPropertiesFormat = new ApplicationGatewayBackendAddressPoolPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backendIPConfigurations".equals(fieldName)) {
                    List backendIpConfigurations;
                    deserializedApplicationGatewayBackendAddressPoolPropertiesFormat.backendIpConfigurations = backendIpConfigurations = reader.readArray(reader1 -> NetworkInterfaceIpConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("backendAddresses".equals(fieldName)) {
                    List backendAddresses;
                    deserializedApplicationGatewayBackendAddressPoolPropertiesFormat.backendAddresses = backendAddresses = reader.readArray(reader1 -> ApplicationGatewayBackendAddress.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayBackendAddressPoolPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayBackendAddressPoolPropertiesFormat;
        });
    }
}

