/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectionMonitorSourceStatus;
import com.azure.resourcemanager.network.models.ConnectionStateSnapshot;
import java.io.IOException;
import java.util.List;

public final class ConnectionMonitorQueryResultInner
implements JsonSerializable<ConnectionMonitorQueryResultInner> {
    private ConnectionMonitorSourceStatus sourceStatus;
    private List<ConnectionStateSnapshot> states;

    public ConnectionMonitorSourceStatus sourceStatus() {
        return this.sourceStatus;
    }

    public ConnectionMonitorQueryResultInner withSourceStatus(ConnectionMonitorSourceStatus sourceStatus) {
        this.sourceStatus = sourceStatus;
        return this;
    }

    public List<ConnectionStateSnapshot> states() {
        return this.states;
    }

    public ConnectionMonitorQueryResultInner withStates(List<ConnectionStateSnapshot> states) {
        this.states = states;
        return this;
    }

    public void validate() {
        if (this.states() != null) {
            this.states().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceStatus", this.sourceStatus == null ? null : this.sourceStatus.toString());
        jsonWriter.writeArrayField("states", this.states, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorQueryResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorQueryResultInner)jsonReader.readObject(reader -> {
            ConnectionMonitorQueryResultInner deserializedConnectionMonitorQueryResultInner = new ConnectionMonitorQueryResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceStatus".equals(fieldName)) {
                    deserializedConnectionMonitorQueryResultInner.sourceStatus = ConnectionMonitorSourceStatus.fromString(reader.getString());
                    continue;
                }
                if ("states".equals(fieldName)) {
                    List states;
                    deserializedConnectionMonitorQueryResultInner.states = states = reader.readArray(reader1 -> ConnectionStateSnapshot.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorQueryResultInner;
        });
    }
}

