/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FirewallPolicyInner;
import java.io.IOException;
import java.util.List;

public final class FirewallPolicyListResult
implements JsonSerializable<FirewallPolicyListResult> {
    private List<FirewallPolicyInner> value;
    private String nextLink;

    public List<FirewallPolicyInner> value() {
        return this.value;
    }

    public FirewallPolicyListResult withValue(List<FirewallPolicyInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public FirewallPolicyListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static FirewallPolicyListResult fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallPolicyListResult)jsonReader.readObject(reader -> {
            FirewallPolicyListResult deserializedFirewallPolicyListResult = new FirewallPolicyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedFirewallPolicyListResult.value = value = reader.readArray(reader1 -> FirewallPolicyInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedFirewallPolicyListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallPolicyListResult;
        });
    }
}

