/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.AzureReachabilityReportInner;
import com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.azure.resourcemanager.network.models.AzureReachabilityReport;
import com.azure.resourcemanager.network.models.AzureReachabilityReportItem;
import com.azure.resourcemanager.network.models.AzureReachabilityReportLocation;
import com.azure.resourcemanager.network.models.AzureReachabilityReportParameters;
import com.azure.resourcemanager.network.models.NetworkWatcher;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

class AzureReachabilityReportImpl
extends ExecutableImpl<AzureReachabilityReport>
implements AzureReachabilityReport,
AzureReachabilityReport.Definition {
    private final NetworkWatcherImpl parent;
    private AzureReachabilityReportParameters parameters = new AzureReachabilityReportParameters();
    private AzureReachabilityReportInner inner;

    AzureReachabilityReportImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public String aggregationLevel() {
        return this.inner.aggregationLevel();
    }

    @Override
    public AzureReachabilityReportLocation providerLocation() {
        return this.inner.providerLocation();
    }

    @Override
    public List<AzureReachabilityReportItem> reachabilityReport() {
        return Collections.unmodifiableList(this.inner.reachabilityReport());
    }

    @Override
    public AzureReachabilityReportParameters azureReachabilityReportParameters() {
        return this.parameters;
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    public AzureReachabilityReportInner innerModel() {
        return this.inner;
    }

    public Mono<AzureReachabilityReport> executeWorkAsync() {
        return ((NetworkManagementClient)((NetworkManager)((Object)this.parent().manager())).serviceClient()).getNetworkWatchers().getAzureReachabilityReportAsync(this.parent().resourceGroupName(), this.parent().name(), this.parameters).map(azureReachabilityReportListInner -> {
            this.inner = azureReachabilityReportListInner;
            return this;
        });
    }

    @Override
    public AzureReachabilityReportImpl withProviderLocation(String country) {
        this.parameters.withProviderLocation(new AzureReachabilityReportLocation().withCountry(country));
        return this;
    }

    @Override
    public AzureReachabilityReportImpl withProviderLocation(String country, String state) {
        this.parameters.withProviderLocation(new AzureReachabilityReportLocation().withCountry(country).withState(state));
        return this;
    }

    @Override
    public AzureReachabilityReportImpl withProviderLocation(String country, String state, String city) {
        this.parameters.withProviderLocation(new AzureReachabilityReportLocation().withCountry(country).withState(state).withCity(city));
        return this;
    }

    @Override
    public AzureReachabilityReportImpl withStartTime(OffsetDateTime startTime) {
        this.parameters.withStartTime(startTime);
        return this;
    }

    @Override
    public AzureReachabilityReportImpl withEndTime(OffsetDateTime endTime) {
        this.parameters.withEndTime(endTime);
        return this;
    }

    @Override
    public AzureReachabilityReport.DefinitionStages.WithExecute withAzureLocations(String ... azureLocations) {
        this.parameters.withAzureLocations(Arrays.asList(azureLocations));
        return this;
    }

    @Override
    public AzureReachabilityReport.DefinitionStages.WithExecute withProviders(String ... providers) {
        this.parameters.withProviders(Arrays.asList(providers));
        return this;
    }
}

