/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VpnSiteLinkInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.DeviceProperties;
import com.azure.resourcemanager.network.models.O365PolicyProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VpnSiteProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VpnSiteProperties.class);
    @JsonProperty(value="virtualWan")
    private SubResource virtualWan;
    @JsonProperty(value="deviceProperties")
    private DeviceProperties deviceProperties;
    @JsonProperty(value="ipAddress")
    private String ipAddress;
    @JsonProperty(value="siteKey")
    private String siteKey;
    @JsonProperty(value="addressSpace")
    private AddressSpace addressSpace;
    @JsonProperty(value="bgpProperties")
    private BgpSettings bgpProperties;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="isSecuritySite")
    private Boolean isSecuritySite;
    @JsonProperty(value="vpnSiteLinks")
    private List<VpnSiteLinkInner> vpnSiteLinks;
    @JsonProperty(value="o365Policy")
    private O365PolicyProperties o365Policy;

    public SubResource virtualWan() {
        return this.virtualWan;
    }

    public VpnSiteProperties withVirtualWan(SubResource virtualWan) {
        this.virtualWan = virtualWan;
        return this;
    }

    public DeviceProperties deviceProperties() {
        return this.deviceProperties;
    }

    public VpnSiteProperties withDeviceProperties(DeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public VpnSiteProperties withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String siteKey() {
        return this.siteKey;
    }

    public VpnSiteProperties withSiteKey(String siteKey) {
        this.siteKey = siteKey;
        return this;
    }

    public AddressSpace addressSpace() {
        return this.addressSpace;
    }

    public VpnSiteProperties withAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    public BgpSettings bgpProperties() {
        return this.bgpProperties;
    }

    public VpnSiteProperties withBgpProperties(BgpSettings bgpProperties) {
        this.bgpProperties = bgpProperties;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean isSecuritySite() {
        return this.isSecuritySite;
    }

    public VpnSiteProperties withIsSecuritySite(Boolean isSecuritySite) {
        this.isSecuritySite = isSecuritySite;
        return this;
    }

    public List<VpnSiteLinkInner> vpnSiteLinks() {
        return this.vpnSiteLinks;
    }

    public VpnSiteProperties withVpnSiteLinks(List<VpnSiteLinkInner> vpnSiteLinks) {
        this.vpnSiteLinks = vpnSiteLinks;
        return this;
    }

    public O365PolicyProperties o365Policy() {
        return this.o365Policy;
    }

    public VpnSiteProperties withO365Policy(O365PolicyProperties o365Policy) {
        this.o365Policy = o365Policy;
        return this;
    }

    public void validate() {
        if (this.deviceProperties() != null) {
            this.deviceProperties().validate();
        }
        if (this.addressSpace() != null) {
            this.addressSpace().validate();
        }
        if (this.bgpProperties() != null) {
            this.bgpProperties().validate();
        }
        if (this.vpnSiteLinks() != null) {
            this.vpnSiteLinks().forEach(e -> e.validate());
        }
        if (this.o365Policy() != null) {
            this.o365Policy().validate();
        }
    }
}

