/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VirtualApplianceSiteProperties;
import com.azure.resourcemanager.network.models.Office365PolicyProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class VirtualApplianceSiteInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualApplianceSiteInner.class);
    @JsonProperty(value="properties")
    private VirtualApplianceSiteProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private VirtualApplianceSiteProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public VirtualApplianceSiteInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public VirtualApplianceSiteInner withId(String id) {
        super.withId(id);
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public VirtualApplianceSiteInner withAddressPrefix(String addressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualApplianceSiteProperties();
        }
        this.innerProperties().withAddressPrefix(addressPrefix);
        return this;
    }

    public Office365PolicyProperties o365Policy() {
        return this.innerProperties() == null ? null : this.innerProperties().o365Policy();
    }

    public VirtualApplianceSiteInner withO365Policy(Office365PolicyProperties o365Policy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualApplianceSiteProperties();
        }
        this.innerProperties().withO365Policy(o365Policy);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

