/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.RouteInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RouteTablePropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RouteTablePropertiesFormat.class);
    @JsonProperty(value="routes")
    private List<RouteInner> routes;
    @JsonProperty(value="subnets", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubnetInner> subnets;
    @JsonProperty(value="disableBgpRoutePropagation")
    private Boolean disableBgpRoutePropagation;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    public List<RouteInner> routes() {
        return this.routes;
    }

    public RouteTablePropertiesFormat withRoutes(List<RouteInner> routes) {
        this.routes = routes;
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public Boolean disableBgpRoutePropagation() {
        return this.disableBgpRoutePropagation;
    }

    public RouteTablePropertiesFormat withDisableBgpRoutePropagation(Boolean disableBgpRoutePropagation) {
        this.disableBgpRoutePropagation = disableBgpRoutePropagation;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
    }
}

