/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.OperationPropertiesFormat;
import com.azure.resourcemanager.network.models.OperationDisplay;
import com.azure.resourcemanager.network.models.OperationPropertiesFormatServiceSpecification;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class OperationInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OperationInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="display")
    private OperationDisplay display;
    @JsonProperty(value="origin")
    private String origin;
    @JsonProperty(value="properties")
    private OperationPropertiesFormat innerProperties;

    public String name() {
        return this.name;
    }

    public OperationInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public OperationInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    private OperationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public OperationPropertiesFormatServiceSpecification serviceSpecification() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceSpecification();
    }

    public OperationInner withServiceSpecification(OperationPropertiesFormatServiceSpecification serviceSpecification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationPropertiesFormat();
        }
        this.innerProperties().withServiceSpecification(serviceSpecification);
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

