/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.VolumeQuotaRulesProperties;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import com.azure.resourcemanager.netapp.models.Type;
import java.io.IOException;
import java.util.Map;

public final class VolumeQuotaRulePatch
implements JsonSerializable<VolumeQuotaRulePatch> {
    private Map<String, String> tags;
    private VolumeQuotaRulesProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public VolumeQuotaRulePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private VolumeQuotaRulesProperties innerProperties() {
        return this.innerProperties;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Long quotaSizeInKiBs() {
        return this.innerProperties() == null ? null : this.innerProperties().quotaSizeInKiBs();
    }

    public VolumeQuotaRulePatch withQuotaSizeInKiBs(Long quotaSizeInKiBs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeQuotaRulesProperties();
        }
        this.innerProperties().withQuotaSizeInKiBs(quotaSizeInKiBs);
        return this;
    }

    public Type quotaType() {
        return this.innerProperties() == null ? null : this.innerProperties().quotaType();
    }

    public VolumeQuotaRulePatch withQuotaType(Type quotaType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeQuotaRulesProperties();
        }
        this.innerProperties().withQuotaType(quotaType);
        return this;
    }

    public String quotaTarget() {
        return this.innerProperties() == null ? null : this.innerProperties().quotaTarget();
    }

    public VolumeQuotaRulePatch withQuotaTarget(String quotaTarget) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeQuotaRulesProperties();
        }
        this.innerProperties().withQuotaTarget(quotaTarget);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VolumeQuotaRulePatch fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeQuotaRulePatch)jsonReader.readObject(reader -> {
            VolumeQuotaRulePatch deserializedVolumeQuotaRulePatch = new VolumeQuotaRulePatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedVolumeQuotaRulePatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVolumeQuotaRulePatch.innerProperties = VolumeQuotaRulesProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeQuotaRulePatch;
        });
    }
}

