/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.Dimension;
import com.azure.resourcemanager.netapp.models.MetricAggregationType;
import java.io.IOException;
import java.util.List;

public final class MetricSpecification
implements JsonSerializable<MetricSpecification> {
    private String name;
    private String displayName;
    private String displayDescription;
    private String unit;
    private List<MetricAggregationType> supportedAggregationTypes;
    private List<String> supportedTimeGrainTypes;
    private String internalMetricName;
    private Boolean enableRegionalMdmAccount;
    private String sourceMdmAccount;
    private String sourceMdmNamespace;
    private List<Dimension> dimensions;
    private String aggregationType;
    private Boolean fillGapWithZero;
    private String category;
    private String resourceIdDimensionNameOverride;
    private Boolean isInternal;

    private MetricSpecification() {
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public String displayDescription() {
        return this.displayDescription;
    }

    public String unit() {
        return this.unit;
    }

    public List<MetricAggregationType> supportedAggregationTypes() {
        return this.supportedAggregationTypes;
    }

    public List<String> supportedTimeGrainTypes() {
        return this.supportedTimeGrainTypes;
    }

    public String internalMetricName() {
        return this.internalMetricName;
    }

    public Boolean enableRegionalMdmAccount() {
        return this.enableRegionalMdmAccount;
    }

    public String sourceMdmAccount() {
        return this.sourceMdmAccount;
    }

    public String sourceMdmNamespace() {
        return this.sourceMdmNamespace;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public String aggregationType() {
        return this.aggregationType;
    }

    public Boolean fillGapWithZero() {
        return this.fillGapWithZero;
    }

    public String category() {
        return this.category;
    }

    public String resourceIdDimensionNameOverride() {
        return this.resourceIdDimensionNameOverride;
    }

    public Boolean isInternal() {
        return this.isInternal;
    }

    public void validate() {
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeArrayField("supportedAggregationTypes", this.supportedAggregationTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("supportedTimeGrainTypes", this.supportedTimeGrainTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("internalMetricName", this.internalMetricName);
        jsonWriter.writeBooleanField("enableRegionalMdmAccount", this.enableRegionalMdmAccount);
        jsonWriter.writeStringField("sourceMdmAccount", this.sourceMdmAccount);
        jsonWriter.writeStringField("sourceMdmNamespace", this.sourceMdmNamespace);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeBooleanField("fillGapWithZero", this.fillGapWithZero);
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("resourceIdDimensionNameOverride", this.resourceIdDimensionNameOverride);
        jsonWriter.writeBooleanField("isInternal", this.isInternal);
        return jsonWriter.writeEndObject();
    }

    public static MetricSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (MetricSpecification)jsonReader.readObject(reader -> {
            MetricSpecification deserializedMetricSpecification = new MetricSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricSpecification.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMetricSpecification.displayName = reader.getString();
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedMetricSpecification.displayDescription = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricSpecification.unit = reader.getString();
                    continue;
                }
                if ("supportedAggregationTypes".equals(fieldName)) {
                    List supportedAggregationTypes;
                    deserializedMetricSpecification.supportedAggregationTypes = supportedAggregationTypes = reader.readArray(reader1 -> MetricAggregationType.fromString(reader1.getString()));
                    continue;
                }
                if ("supportedTimeGrainTypes".equals(fieldName)) {
                    List supportedTimeGrainTypes;
                    deserializedMetricSpecification.supportedTimeGrainTypes = supportedTimeGrainTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("internalMetricName".equals(fieldName)) {
                    deserializedMetricSpecification.internalMetricName = reader.getString();
                    continue;
                }
                if ("enableRegionalMdmAccount".equals(fieldName)) {
                    deserializedMetricSpecification.enableRegionalMdmAccount = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sourceMdmAccount".equals(fieldName)) {
                    deserializedMetricSpecification.sourceMdmAccount = reader.getString();
                    continue;
                }
                if ("sourceMdmNamespace".equals(fieldName)) {
                    deserializedMetricSpecification.sourceMdmNamespace = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedMetricSpecification.dimensions = dimensions = reader.readArray(reader1 -> Dimension.fromJson(reader1));
                    continue;
                }
                if ("aggregationType".equals(fieldName)) {
                    deserializedMetricSpecification.aggregationType = reader.getString();
                    continue;
                }
                if ("fillGapWithZero".equals(fieldName)) {
                    deserializedMetricSpecification.fillGapWithZero = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedMetricSpecification.category = reader.getString();
                    continue;
                }
                if ("resourceIdDimensionNameOverride".equals(fieldName)) {
                    deserializedMetricSpecification.resourceIdDimensionNameOverride = reader.getString();
                    continue;
                }
                if ("isInternal".equals(fieldName)) {
                    deserializedMetricSpecification.isInternal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricSpecification;
        });
    }
}

