/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BackupRestoreFiles
implements JsonSerializable<BackupRestoreFiles> {
    private List<String> fileList;
    private String restoreFilePath;
    private String destinationVolumeId;
    private static final ClientLogger LOGGER = new ClientLogger(BackupRestoreFiles.class);

    public List<String> fileList() {
        return this.fileList;
    }

    public BackupRestoreFiles withFileList(List<String> fileList) {
        this.fileList = fileList;
        return this;
    }

    public String restoreFilePath() {
        return this.restoreFilePath;
    }

    public BackupRestoreFiles withRestoreFilePath(String restoreFilePath) {
        this.restoreFilePath = restoreFilePath;
        return this;
    }

    public String destinationVolumeId() {
        return this.destinationVolumeId;
    }

    public BackupRestoreFiles withDestinationVolumeId(String destinationVolumeId) {
        this.destinationVolumeId = destinationVolumeId;
        return this;
    }

    public void validate() {
        if (this.fileList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fileList in model BackupRestoreFiles"));
        }
        if (this.destinationVolumeId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationVolumeId in model BackupRestoreFiles"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("fileList", this.fileList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("destinationVolumeId", this.destinationVolumeId);
        jsonWriter.writeStringField("restoreFilePath", this.restoreFilePath);
        return jsonWriter.writeEndObject();
    }

    public static BackupRestoreFiles fromJson(JsonReader jsonReader) throws IOException {
        return (BackupRestoreFiles)jsonReader.readObject(reader -> {
            BackupRestoreFiles deserializedBackupRestoreFiles = new BackupRestoreFiles();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileList".equals(fieldName)) {
                    List fileList;
                    deserializedBackupRestoreFiles.fileList = fileList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationVolumeId".equals(fieldName)) {
                    deserializedBackupRestoreFiles.destinationVolumeId = reader.getString();
                    continue;
                }
                if ("restoreFilePath".equals(fieldName)) {
                    deserializedBackupRestoreFiles.restoreFilePath = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupRestoreFiles;
        });
    }
}

