/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.ReplicationInner;
import java.io.IOException;
import java.util.List;

public final class ListReplications
implements JsonSerializable<ListReplications> {
    private List<ReplicationInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ListReplications.class);

    private ListReplications() {
    }

    public List<ReplicationInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ListReplications"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ListReplications fromJson(JsonReader jsonReader) throws IOException {
        return (ListReplications)jsonReader.readObject(reader -> {
            ListReplications deserializedListReplications = new ListReplications();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedListReplications.value = value = reader.readArray(reader1 -> ReplicationInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedListReplications.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedListReplications;
        });
    }
}

