/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.NetAppResourceRegionInfosClient;
import com.azure.resourcemanager.netapp.fluent.models.RegionInfoResourceInner;
import com.azure.resourcemanager.netapp.implementation.RegionInfoResourceImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.NetAppResourceRegionInfos;
import com.azure.resourcemanager.netapp.models.RegionInfoResource;

public final class NetAppResourceRegionInfosImpl
implements NetAppResourceRegionInfos {
    private static final ClientLogger LOGGER = new ClientLogger(NetAppResourceRegionInfosImpl.class);
    private final NetAppResourceRegionInfosClient innerClient;
    private final NetAppFilesManager serviceManager;

    public NetAppResourceRegionInfosImpl(NetAppResourceRegionInfosClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<RegionInfoResource> getWithResponse(String location, Context context) {
        Response<RegionInfoResourceInner> inner = this.serviceClient().getWithResponse(location, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RegionInfoResourceImpl((RegionInfoResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RegionInfoResource get(String location) {
        RegionInfoResourceInner inner = this.serviceClient().get(location);
        if (inner != null) {
            return new RegionInfoResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<RegionInfoResource> list(String location) {
        PagedIterable<RegionInfoResourceInner> inner = this.serviceClient().list(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegionInfoResourceImpl((RegionInfoResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RegionInfoResource> list(String location, Context context) {
        PagedIterable<RegionInfoResourceInner> inner = this.serviceClient().list(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegionInfoResourceImpl((RegionInfoResourceInner)((Object)inner1), this.manager()));
    }

    private NetAppResourceRegionInfosClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }
}

