/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.AccountsClient;
import com.azure.resourcemanager.netapp.fluent.models.GetKeyVaultStatusResponseInner;
import com.azure.resourcemanager.netapp.fluent.models.NetAppAccountInner;
import com.azure.resourcemanager.netapp.implementation.GetKeyVaultStatusResponseImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppAccountImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.Accounts;
import com.azure.resourcemanager.netapp.models.ChangeKeyVault;
import com.azure.resourcemanager.netapp.models.EncryptionTransitionRequest;
import com.azure.resourcemanager.netapp.models.GetKeyVaultStatusResponse;
import com.azure.resourcemanager.netapp.models.NetAppAccount;

public final class AccountsImpl
implements Accounts {
    private static final ClientLogger LOGGER = new ClientLogger(AccountsImpl.class);
    private final AccountsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public AccountsImpl(AccountsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NetAppAccount> getByResourceGroupWithResponse(String resourceGroupName, String accountName, Context context) {
        Response<NetAppAccountInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, accountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NetAppAccountImpl((NetAppAccountInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NetAppAccount getByResourceGroup(String resourceGroupName, String accountName) {
        NetAppAccountInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, accountName);
        if (inner != null) {
            return new NetAppAccountImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String accountName) {
        this.serviceClient().delete(resourceGroupName, accountName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, context);
    }

    @Override
    public PagedIterable<NetAppAccount> listByResourceGroup(String resourceGroupName) {
        PagedIterable<NetAppAccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetAppAccountImpl((NetAppAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetAppAccount> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<NetAppAccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetAppAccountImpl((NetAppAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetAppAccount> list() {
        PagedIterable<NetAppAccountInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetAppAccountImpl((NetAppAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetAppAccount> list(Context context) {
        PagedIterable<NetAppAccountInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetAppAccountImpl((NetAppAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public void renewCredentials(String resourceGroupName, String accountName) {
        this.serviceClient().renewCredentials(resourceGroupName, accountName);
    }

    @Override
    public void renewCredentials(String resourceGroupName, String accountName, Context context) {
        this.serviceClient().renewCredentials(resourceGroupName, accountName, context);
    }

    @Override
    public void transitionToCmk(String resourceGroupName, String accountName) {
        this.serviceClient().transitionToCmk(resourceGroupName, accountName);
    }

    @Override
    public void transitionToCmk(String resourceGroupName, String accountName, EncryptionTransitionRequest body, Context context) {
        this.serviceClient().transitionToCmk(resourceGroupName, accountName, body, context);
    }

    @Override
    public GetKeyVaultStatusResponse getChangeKeyVaultInformation(String resourceGroupName, String accountName) {
        GetKeyVaultStatusResponseInner inner = this.serviceClient().getChangeKeyVaultInformation(resourceGroupName, accountName);
        if (inner != null) {
            return new GetKeyVaultStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public GetKeyVaultStatusResponse getChangeKeyVaultInformation(String resourceGroupName, String accountName, Context context) {
        GetKeyVaultStatusResponseInner inner = this.serviceClient().getChangeKeyVaultInformation(resourceGroupName, accountName, context);
        if (inner != null) {
            return new GetKeyVaultStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void changeKeyVault(String resourceGroupName, String accountName) {
        this.serviceClient().changeKeyVault(resourceGroupName, accountName);
    }

    @Override
    public void changeKeyVault(String resourceGroupName, String accountName, ChangeKeyVault body, Context context) {
        this.serviceClient().changeKeyVault(resourceGroupName, accountName, body, context);
    }

    @Override
    public NetAppAccount getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        return (NetAppAccount)this.getByResourceGroupWithResponse(resourceGroupName, accountName, Context.NONE).getValue();
    }

    @Override
    public Response<NetAppAccount> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, accountName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        this.delete(resourceGroupName, accountName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        this.delete(resourceGroupName, accountName, context);
    }

    private AccountsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public NetAppAccountImpl define(String name) {
        return new NetAppAccountImpl(name, this.manager());
    }
}

