/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.AcceptGrowCapacityPoolForShortTermCloneSplit;
import com.azure.resourcemanager.netapp.models.AvsDataStore;
import com.azure.resourcemanager.netapp.models.CoolAccessRetrievalPolicy;
import com.azure.resourcemanager.netapp.models.CoolAccessTieringPolicy;
import com.azure.resourcemanager.netapp.models.EnableSubvolumes;
import com.azure.resourcemanager.netapp.models.EncryptionKeySource;
import com.azure.resourcemanager.netapp.models.FileAccessLogs;
import com.azure.resourcemanager.netapp.models.MountTargetProperties;
import com.azure.resourcemanager.netapp.models.NetworkFeatures;
import com.azure.resourcemanager.netapp.models.PlacementKeyValuePairs;
import com.azure.resourcemanager.netapp.models.SecurityStyle;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import com.azure.resourcemanager.netapp.models.SmbAccessBasedEnumeration;
import com.azure.resourcemanager.netapp.models.SmbNonBrowsable;
import com.azure.resourcemanager.netapp.models.VolumePropertiesDataProtection;
import com.azure.resourcemanager.netapp.models.VolumePropertiesExportPolicy;
import com.azure.resourcemanager.netapp.models.VolumeStorageToNetworkProximity;
import java.io.IOException;
import java.util.List;

public final class VolumeProperties
implements JsonSerializable<VolumeProperties> {
    private String fileSystemId;
    private String creationToken;
    private ServiceLevel serviceLevel;
    private long usageThreshold;
    private VolumePropertiesExportPolicy exportPolicy;
    private List<String> protocolTypes;
    private String provisioningState;
    private String snapshotId;
    private Boolean deleteBaseSnapshot;
    private String backupId;
    private String baremetalTenantId;
    private String subnetId;
    private NetworkFeatures networkFeatures;
    private NetworkFeatures effectiveNetworkFeatures;
    private String networkSiblingSetId;
    private VolumeStorageToNetworkProximity storageToNetworkProximity;
    private List<MountTargetProperties> mountTargets;
    private String volumeType;
    private VolumePropertiesDataProtection dataProtection;
    private AcceptGrowCapacityPoolForShortTermCloneSplit acceptGrowCapacityPoolForShortTermCloneSplit;
    private Boolean isRestoring;
    private Boolean snapshotDirectoryVisible;
    private Boolean kerberosEnabled;
    private SecurityStyle securityStyle;
    private Boolean smbEncryption;
    private SmbAccessBasedEnumeration smbAccessBasedEnumeration;
    private SmbNonBrowsable smbNonBrowsable;
    private Boolean smbContinuouslyAvailable;
    private Float throughputMibps;
    private Float actualThroughputMibps;
    private EncryptionKeySource encryptionKeySource;
    private String keyVaultPrivateEndpointResourceId;
    private Boolean ldapEnabled;
    private Boolean coolAccess;
    private Integer coolnessPeriod;
    private CoolAccessRetrievalPolicy coolAccessRetrievalPolicy;
    private CoolAccessTieringPolicy coolAccessTieringPolicy;
    private String unixPermissions;
    private Integer cloneProgress;
    private FileAccessLogs fileAccessLogs;
    private AvsDataStore avsDataStore;
    private List<String> dataStoreResourceId;
    private Boolean isDefaultQuotaEnabled;
    private Long defaultUserQuotaInKiBs;
    private Long defaultGroupQuotaInKiBs;
    private Long maximumNumberOfFiles;
    private String volumeGroupName;
    private String capacityPoolResourceId;
    private String proximityPlacementGroup;
    private String t2Network;
    private String volumeSpecName;
    private Boolean encrypted;
    private List<PlacementKeyValuePairs> placementRules;
    private EnableSubvolumes enableSubvolumes;
    private String provisionedAvailabilityZone;
    private Boolean isLargeVolume;
    private String originatingResourceId;
    private Long inheritedSizeInBytes;
    private static final ClientLogger LOGGER = new ClientLogger(VolumeProperties.class);

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public VolumeProperties withCreationToken(String creationToken) {
        this.creationToken = creationToken;
        return this;
    }

    public ServiceLevel serviceLevel() {
        return this.serviceLevel;
    }

    public VolumeProperties withServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    public long usageThreshold() {
        return this.usageThreshold;
    }

    public VolumeProperties withUsageThreshold(long usageThreshold) {
        this.usageThreshold = usageThreshold;
        return this;
    }

    public VolumePropertiesExportPolicy exportPolicy() {
        return this.exportPolicy;
    }

    public VolumeProperties withExportPolicy(VolumePropertiesExportPolicy exportPolicy) {
        this.exportPolicy = exportPolicy;
        return this;
    }

    public List<String> protocolTypes() {
        return this.protocolTypes;
    }

    public VolumeProperties withProtocolTypes(List<String> protocolTypes) {
        this.protocolTypes = protocolTypes;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public VolumeProperties withSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    public Boolean deleteBaseSnapshot() {
        return this.deleteBaseSnapshot;
    }

    public VolumeProperties withDeleteBaseSnapshot(Boolean deleteBaseSnapshot) {
        this.deleteBaseSnapshot = deleteBaseSnapshot;
        return this;
    }

    public String backupId() {
        return this.backupId;
    }

    public VolumeProperties withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public String baremetalTenantId() {
        return this.baremetalTenantId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public VolumeProperties withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public NetworkFeatures networkFeatures() {
        return this.networkFeatures;
    }

    public VolumeProperties withNetworkFeatures(NetworkFeatures networkFeatures) {
        this.networkFeatures = networkFeatures;
        return this;
    }

    public NetworkFeatures effectiveNetworkFeatures() {
        return this.effectiveNetworkFeatures;
    }

    public String networkSiblingSetId() {
        return this.networkSiblingSetId;
    }

    public VolumeStorageToNetworkProximity storageToNetworkProximity() {
        return this.storageToNetworkProximity;
    }

    public List<MountTargetProperties> mountTargets() {
        return this.mountTargets;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public VolumeProperties withVolumeType(String volumeType) {
        this.volumeType = volumeType;
        return this;
    }

    public VolumePropertiesDataProtection dataProtection() {
        return this.dataProtection;
    }

    public VolumeProperties withDataProtection(VolumePropertiesDataProtection dataProtection) {
        this.dataProtection = dataProtection;
        return this;
    }

    public AcceptGrowCapacityPoolForShortTermCloneSplit acceptGrowCapacityPoolForShortTermCloneSplit() {
        return this.acceptGrowCapacityPoolForShortTermCloneSplit;
    }

    public VolumeProperties withAcceptGrowCapacityPoolForShortTermCloneSplit(AcceptGrowCapacityPoolForShortTermCloneSplit acceptGrowCapacityPoolForShortTermCloneSplit) {
        this.acceptGrowCapacityPoolForShortTermCloneSplit = acceptGrowCapacityPoolForShortTermCloneSplit;
        return this;
    }

    public Boolean isRestoring() {
        return this.isRestoring;
    }

    public Boolean snapshotDirectoryVisible() {
        return this.snapshotDirectoryVisible;
    }

    public VolumeProperties withSnapshotDirectoryVisible(Boolean snapshotDirectoryVisible) {
        this.snapshotDirectoryVisible = snapshotDirectoryVisible;
        return this;
    }

    public Boolean kerberosEnabled() {
        return this.kerberosEnabled;
    }

    public VolumeProperties withKerberosEnabled(Boolean kerberosEnabled) {
        this.kerberosEnabled = kerberosEnabled;
        return this;
    }

    public SecurityStyle securityStyle() {
        return this.securityStyle;
    }

    public VolumeProperties withSecurityStyle(SecurityStyle securityStyle) {
        this.securityStyle = securityStyle;
        return this;
    }

    public Boolean smbEncryption() {
        return this.smbEncryption;
    }

    public VolumeProperties withSmbEncryption(Boolean smbEncryption) {
        this.smbEncryption = smbEncryption;
        return this;
    }

    public SmbAccessBasedEnumeration smbAccessBasedEnumeration() {
        return this.smbAccessBasedEnumeration;
    }

    public VolumeProperties withSmbAccessBasedEnumeration(SmbAccessBasedEnumeration smbAccessBasedEnumeration) {
        this.smbAccessBasedEnumeration = smbAccessBasedEnumeration;
        return this;
    }

    public SmbNonBrowsable smbNonBrowsable() {
        return this.smbNonBrowsable;
    }

    public VolumeProperties withSmbNonBrowsable(SmbNonBrowsable smbNonBrowsable) {
        this.smbNonBrowsable = smbNonBrowsable;
        return this;
    }

    public Boolean smbContinuouslyAvailable() {
        return this.smbContinuouslyAvailable;
    }

    public VolumeProperties withSmbContinuouslyAvailable(Boolean smbContinuouslyAvailable) {
        this.smbContinuouslyAvailable = smbContinuouslyAvailable;
        return this;
    }

    public Float throughputMibps() {
        return this.throughputMibps;
    }

    public VolumeProperties withThroughputMibps(Float throughputMibps) {
        this.throughputMibps = throughputMibps;
        return this;
    }

    public Float actualThroughputMibps() {
        return this.actualThroughputMibps;
    }

    public EncryptionKeySource encryptionKeySource() {
        return this.encryptionKeySource;
    }

    public VolumeProperties withEncryptionKeySource(EncryptionKeySource encryptionKeySource) {
        this.encryptionKeySource = encryptionKeySource;
        return this;
    }

    public String keyVaultPrivateEndpointResourceId() {
        return this.keyVaultPrivateEndpointResourceId;
    }

    public VolumeProperties withKeyVaultPrivateEndpointResourceId(String keyVaultPrivateEndpointResourceId) {
        this.keyVaultPrivateEndpointResourceId = keyVaultPrivateEndpointResourceId;
        return this;
    }

    public Boolean ldapEnabled() {
        return this.ldapEnabled;
    }

    public VolumeProperties withLdapEnabled(Boolean ldapEnabled) {
        this.ldapEnabled = ldapEnabled;
        return this;
    }

    public Boolean coolAccess() {
        return this.coolAccess;
    }

    public VolumeProperties withCoolAccess(Boolean coolAccess) {
        this.coolAccess = coolAccess;
        return this;
    }

    public Integer coolnessPeriod() {
        return this.coolnessPeriod;
    }

    public VolumeProperties withCoolnessPeriod(Integer coolnessPeriod) {
        this.coolnessPeriod = coolnessPeriod;
        return this;
    }

    public CoolAccessRetrievalPolicy coolAccessRetrievalPolicy() {
        return this.coolAccessRetrievalPolicy;
    }

    public VolumeProperties withCoolAccessRetrievalPolicy(CoolAccessRetrievalPolicy coolAccessRetrievalPolicy) {
        this.coolAccessRetrievalPolicy = coolAccessRetrievalPolicy;
        return this;
    }

    public CoolAccessTieringPolicy coolAccessTieringPolicy() {
        return this.coolAccessTieringPolicy;
    }

    public VolumeProperties withCoolAccessTieringPolicy(CoolAccessTieringPolicy coolAccessTieringPolicy) {
        this.coolAccessTieringPolicy = coolAccessTieringPolicy;
        return this;
    }

    public String unixPermissions() {
        return this.unixPermissions;
    }

    public VolumeProperties withUnixPermissions(String unixPermissions) {
        this.unixPermissions = unixPermissions;
        return this;
    }

    public Integer cloneProgress() {
        return this.cloneProgress;
    }

    public FileAccessLogs fileAccessLogs() {
        return this.fileAccessLogs;
    }

    public AvsDataStore avsDataStore() {
        return this.avsDataStore;
    }

    public VolumeProperties withAvsDataStore(AvsDataStore avsDataStore) {
        this.avsDataStore = avsDataStore;
        return this;
    }

    public List<String> dataStoreResourceId() {
        return this.dataStoreResourceId;
    }

    public Boolean isDefaultQuotaEnabled() {
        return this.isDefaultQuotaEnabled;
    }

    public VolumeProperties withIsDefaultQuotaEnabled(Boolean isDefaultQuotaEnabled) {
        this.isDefaultQuotaEnabled = isDefaultQuotaEnabled;
        return this;
    }

    public Long defaultUserQuotaInKiBs() {
        return this.defaultUserQuotaInKiBs;
    }

    public VolumeProperties withDefaultUserQuotaInKiBs(Long defaultUserQuotaInKiBs) {
        this.defaultUserQuotaInKiBs = defaultUserQuotaInKiBs;
        return this;
    }

    public Long defaultGroupQuotaInKiBs() {
        return this.defaultGroupQuotaInKiBs;
    }

    public VolumeProperties withDefaultGroupQuotaInKiBs(Long defaultGroupQuotaInKiBs) {
        this.defaultGroupQuotaInKiBs = defaultGroupQuotaInKiBs;
        return this;
    }

    public Long maximumNumberOfFiles() {
        return this.maximumNumberOfFiles;
    }

    public String volumeGroupName() {
        return this.volumeGroupName;
    }

    public String capacityPoolResourceId() {
        return this.capacityPoolResourceId;
    }

    public VolumeProperties withCapacityPoolResourceId(String capacityPoolResourceId) {
        this.capacityPoolResourceId = capacityPoolResourceId;
        return this;
    }

    public String proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VolumeProperties withProximityPlacementGroup(String proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public String t2Network() {
        return this.t2Network;
    }

    public String volumeSpecName() {
        return this.volumeSpecName;
    }

    public VolumeProperties withVolumeSpecName(String volumeSpecName) {
        this.volumeSpecName = volumeSpecName;
        return this;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public List<PlacementKeyValuePairs> placementRules() {
        return this.placementRules;
    }

    public VolumeProperties withPlacementRules(List<PlacementKeyValuePairs> placementRules) {
        this.placementRules = placementRules;
        return this;
    }

    public EnableSubvolumes enableSubvolumes() {
        return this.enableSubvolumes;
    }

    public VolumeProperties withEnableSubvolumes(EnableSubvolumes enableSubvolumes) {
        this.enableSubvolumes = enableSubvolumes;
        return this;
    }

    public String provisionedAvailabilityZone() {
        return this.provisionedAvailabilityZone;
    }

    public Boolean isLargeVolume() {
        return this.isLargeVolume;
    }

    public VolumeProperties withIsLargeVolume(Boolean isLargeVolume) {
        this.isLargeVolume = isLargeVolume;
        return this;
    }

    public String originatingResourceId() {
        return this.originatingResourceId;
    }

    public Long inheritedSizeInBytes() {
        return this.inheritedSizeInBytes;
    }

    public void validate() {
        if (this.creationToken() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property creationToken in model VolumeProperties"));
        }
        if (this.exportPolicy() != null) {
            this.exportPolicy().validate();
        }
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model VolumeProperties"));
        }
        if (this.mountTargets() != null) {
            this.mountTargets().forEach(e -> e.validate());
        }
        if (this.dataProtection() != null) {
            this.dataProtection().validate();
        }
        if (this.placementRules() != null) {
            this.placementRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("creationToken", this.creationToken);
        jsonWriter.writeLongField("usageThreshold", this.usageThreshold);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("serviceLevel", this.serviceLevel == null ? null : this.serviceLevel.toString());
        jsonWriter.writeJsonField("exportPolicy", (JsonSerializable)this.exportPolicy);
        jsonWriter.writeArrayField("protocolTypes", this.protocolTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("snapshotId", this.snapshotId);
        jsonWriter.writeBooleanField("deleteBaseSnapshot", this.deleteBaseSnapshot);
        jsonWriter.writeStringField("backupId", this.backupId);
        jsonWriter.writeStringField("networkFeatures", this.networkFeatures == null ? null : this.networkFeatures.toString());
        jsonWriter.writeStringField("volumeType", this.volumeType);
        jsonWriter.writeJsonField("dataProtection", (JsonSerializable)this.dataProtection);
        jsonWriter.writeStringField("acceptGrowCapacityPoolForShortTermCloneSplit", this.acceptGrowCapacityPoolForShortTermCloneSplit == null ? null : this.acceptGrowCapacityPoolForShortTermCloneSplit.toString());
        jsonWriter.writeBooleanField("snapshotDirectoryVisible", this.snapshotDirectoryVisible);
        jsonWriter.writeBooleanField("kerberosEnabled", this.kerberosEnabled);
        jsonWriter.writeStringField("securityStyle", this.securityStyle == null ? null : this.securityStyle.toString());
        jsonWriter.writeBooleanField("smbEncryption", this.smbEncryption);
        jsonWriter.writeStringField("smbAccessBasedEnumeration", this.smbAccessBasedEnumeration == null ? null : this.smbAccessBasedEnumeration.toString());
        jsonWriter.writeStringField("smbNonBrowsable", this.smbNonBrowsable == null ? null : this.smbNonBrowsable.toString());
        jsonWriter.writeBooleanField("smbContinuouslyAvailable", this.smbContinuouslyAvailable);
        jsonWriter.writeNumberField("throughputMibps", (Number)this.throughputMibps);
        jsonWriter.writeStringField("encryptionKeySource", this.encryptionKeySource == null ? null : this.encryptionKeySource.toString());
        jsonWriter.writeStringField("keyVaultPrivateEndpointResourceId", this.keyVaultPrivateEndpointResourceId);
        jsonWriter.writeBooleanField("ldapEnabled", this.ldapEnabled);
        jsonWriter.writeBooleanField("coolAccess", this.coolAccess);
        jsonWriter.writeNumberField("coolnessPeriod", (Number)this.coolnessPeriod);
        jsonWriter.writeStringField("coolAccessRetrievalPolicy", this.coolAccessRetrievalPolicy == null ? null : this.coolAccessRetrievalPolicy.toString());
        jsonWriter.writeStringField("coolAccessTieringPolicy", this.coolAccessTieringPolicy == null ? null : this.coolAccessTieringPolicy.toString());
        jsonWriter.writeStringField("unixPermissions", this.unixPermissions);
        jsonWriter.writeStringField("avsDataStore", this.avsDataStore == null ? null : this.avsDataStore.toString());
        jsonWriter.writeBooleanField("isDefaultQuotaEnabled", this.isDefaultQuotaEnabled);
        jsonWriter.writeNumberField("defaultUserQuotaInKiBs", (Number)this.defaultUserQuotaInKiBs);
        jsonWriter.writeNumberField("defaultGroupQuotaInKiBs", (Number)this.defaultGroupQuotaInKiBs);
        jsonWriter.writeStringField("capacityPoolResourceId", this.capacityPoolResourceId);
        jsonWriter.writeStringField("proximityPlacementGroup", this.proximityPlacementGroup);
        jsonWriter.writeStringField("volumeSpecName", this.volumeSpecName);
        jsonWriter.writeArrayField("placementRules", this.placementRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("enableSubvolumes", this.enableSubvolumes == null ? null : this.enableSubvolumes.toString());
        jsonWriter.writeBooleanField("isLargeVolume", this.isLargeVolume);
        return jsonWriter.writeEndObject();
    }

    public static VolumeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeProperties)jsonReader.readObject(reader -> {
            VolumeProperties deserializedVolumeProperties = new VolumeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationToken".equals(fieldName)) {
                    deserializedVolumeProperties.creationToken = reader.getString();
                    continue;
                }
                if ("usageThreshold".equals(fieldName)) {
                    deserializedVolumeProperties.usageThreshold = reader.getLong();
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedVolumeProperties.subnetId = reader.getString();
                    continue;
                }
                if ("fileSystemId".equals(fieldName)) {
                    deserializedVolumeProperties.fileSystemId = reader.getString();
                    continue;
                }
                if ("serviceLevel".equals(fieldName)) {
                    deserializedVolumeProperties.serviceLevel = ServiceLevel.fromString(reader.getString());
                    continue;
                }
                if ("exportPolicy".equals(fieldName)) {
                    deserializedVolumeProperties.exportPolicy = VolumePropertiesExportPolicy.fromJson(reader);
                    continue;
                }
                if ("protocolTypes".equals(fieldName)) {
                    List protocolTypes;
                    deserializedVolumeProperties.protocolTypes = protocolTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVolumeProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("snapshotId".equals(fieldName)) {
                    deserializedVolumeProperties.snapshotId = reader.getString();
                    continue;
                }
                if ("deleteBaseSnapshot".equals(fieldName)) {
                    deserializedVolumeProperties.deleteBaseSnapshot = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("backupId".equals(fieldName)) {
                    deserializedVolumeProperties.backupId = reader.getString();
                    continue;
                }
                if ("baremetalTenantId".equals(fieldName)) {
                    deserializedVolumeProperties.baremetalTenantId = reader.getString();
                    continue;
                }
                if ("networkFeatures".equals(fieldName)) {
                    deserializedVolumeProperties.networkFeatures = NetworkFeatures.fromString(reader.getString());
                    continue;
                }
                if ("effectiveNetworkFeatures".equals(fieldName)) {
                    deserializedVolumeProperties.effectiveNetworkFeatures = NetworkFeatures.fromString(reader.getString());
                    continue;
                }
                if ("networkSiblingSetId".equals(fieldName)) {
                    deserializedVolumeProperties.networkSiblingSetId = reader.getString();
                    continue;
                }
                if ("storageToNetworkProximity".equals(fieldName)) {
                    deserializedVolumeProperties.storageToNetworkProximity = VolumeStorageToNetworkProximity.fromString(reader.getString());
                    continue;
                }
                if ("mountTargets".equals(fieldName)) {
                    List mountTargets;
                    deserializedVolumeProperties.mountTargets = mountTargets = reader.readArray(reader1 -> MountTargetProperties.fromJson(reader1));
                    continue;
                }
                if ("volumeType".equals(fieldName)) {
                    deserializedVolumeProperties.volumeType = reader.getString();
                    continue;
                }
                if ("dataProtection".equals(fieldName)) {
                    deserializedVolumeProperties.dataProtection = VolumePropertiesDataProtection.fromJson(reader);
                    continue;
                }
                if ("acceptGrowCapacityPoolForShortTermCloneSplit".equals(fieldName)) {
                    deserializedVolumeProperties.acceptGrowCapacityPoolForShortTermCloneSplit = AcceptGrowCapacityPoolForShortTermCloneSplit.fromString(reader.getString());
                    continue;
                }
                if ("isRestoring".equals(fieldName)) {
                    deserializedVolumeProperties.isRestoring = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("snapshotDirectoryVisible".equals(fieldName)) {
                    deserializedVolumeProperties.snapshotDirectoryVisible = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("kerberosEnabled".equals(fieldName)) {
                    deserializedVolumeProperties.kerberosEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("securityStyle".equals(fieldName)) {
                    deserializedVolumeProperties.securityStyle = SecurityStyle.fromString(reader.getString());
                    continue;
                }
                if ("smbEncryption".equals(fieldName)) {
                    deserializedVolumeProperties.smbEncryption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("smbAccessBasedEnumeration".equals(fieldName)) {
                    deserializedVolumeProperties.smbAccessBasedEnumeration = SmbAccessBasedEnumeration.fromString(reader.getString());
                    continue;
                }
                if ("smbNonBrowsable".equals(fieldName)) {
                    deserializedVolumeProperties.smbNonBrowsable = SmbNonBrowsable.fromString(reader.getString());
                    continue;
                }
                if ("smbContinuouslyAvailable".equals(fieldName)) {
                    deserializedVolumeProperties.smbContinuouslyAvailable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("throughputMibps".equals(fieldName)) {
                    deserializedVolumeProperties.throughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("actualThroughputMibps".equals(fieldName)) {
                    deserializedVolumeProperties.actualThroughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("encryptionKeySource".equals(fieldName)) {
                    deserializedVolumeProperties.encryptionKeySource = EncryptionKeySource.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultPrivateEndpointResourceId".equals(fieldName)) {
                    deserializedVolumeProperties.keyVaultPrivateEndpointResourceId = reader.getString();
                    continue;
                }
                if ("ldapEnabled".equals(fieldName)) {
                    deserializedVolumeProperties.ldapEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("coolAccess".equals(fieldName)) {
                    deserializedVolumeProperties.coolAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("coolnessPeriod".equals(fieldName)) {
                    deserializedVolumeProperties.coolnessPeriod = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("coolAccessRetrievalPolicy".equals(fieldName)) {
                    deserializedVolumeProperties.coolAccessRetrievalPolicy = CoolAccessRetrievalPolicy.fromString(reader.getString());
                    continue;
                }
                if ("coolAccessTieringPolicy".equals(fieldName)) {
                    deserializedVolumeProperties.coolAccessTieringPolicy = CoolAccessTieringPolicy.fromString(reader.getString());
                    continue;
                }
                if ("unixPermissions".equals(fieldName)) {
                    deserializedVolumeProperties.unixPermissions = reader.getString();
                    continue;
                }
                if ("cloneProgress".equals(fieldName)) {
                    deserializedVolumeProperties.cloneProgress = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fileAccessLogs".equals(fieldName)) {
                    deserializedVolumeProperties.fileAccessLogs = FileAccessLogs.fromString(reader.getString());
                    continue;
                }
                if ("avsDataStore".equals(fieldName)) {
                    deserializedVolumeProperties.avsDataStore = AvsDataStore.fromString(reader.getString());
                    continue;
                }
                if ("dataStoreResourceId".equals(fieldName)) {
                    List dataStoreResourceId;
                    deserializedVolumeProperties.dataStoreResourceId = dataStoreResourceId = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isDefaultQuotaEnabled".equals(fieldName)) {
                    deserializedVolumeProperties.isDefaultQuotaEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultUserQuotaInKiBs".equals(fieldName)) {
                    deserializedVolumeProperties.defaultUserQuotaInKiBs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("defaultGroupQuotaInKiBs".equals(fieldName)) {
                    deserializedVolumeProperties.defaultGroupQuotaInKiBs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maximumNumberOfFiles".equals(fieldName)) {
                    deserializedVolumeProperties.maximumNumberOfFiles = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("volumeGroupName".equals(fieldName)) {
                    deserializedVolumeProperties.volumeGroupName = reader.getString();
                    continue;
                }
                if ("capacityPoolResourceId".equals(fieldName)) {
                    deserializedVolumeProperties.capacityPoolResourceId = reader.getString();
                    continue;
                }
                if ("proximityPlacementGroup".equals(fieldName)) {
                    deserializedVolumeProperties.proximityPlacementGroup = reader.getString();
                    continue;
                }
                if ("t2Network".equals(fieldName)) {
                    deserializedVolumeProperties.t2Network = reader.getString();
                    continue;
                }
                if ("volumeSpecName".equals(fieldName)) {
                    deserializedVolumeProperties.volumeSpecName = reader.getString();
                    continue;
                }
                if ("encrypted".equals(fieldName)) {
                    deserializedVolumeProperties.encrypted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("placementRules".equals(fieldName)) {
                    List placementRules;
                    deserializedVolumeProperties.placementRules = placementRules = reader.readArray(reader1 -> PlacementKeyValuePairs.fromJson(reader1));
                    continue;
                }
                if ("enableSubvolumes".equals(fieldName)) {
                    deserializedVolumeProperties.enableSubvolumes = EnableSubvolumes.fromString(reader.getString());
                    continue;
                }
                if ("provisionedAvailabilityZone".equals(fieldName)) {
                    deserializedVolumeProperties.provisionedAvailabilityZone = reader.getString();
                    continue;
                }
                if ("isLargeVolume".equals(fieldName)) {
                    deserializedVolumeProperties.isLargeVolume = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("originatingResourceId".equals(fieldName)) {
                    deserializedVolumeProperties.originatingResourceId = reader.getString();
                    continue;
                }
                if ("inheritedSizeInBytes".equals(fieldName)) {
                    deserializedVolumeProperties.inheritedSizeInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeProperties;
        });
    }
}

