/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.EndpointType;
import com.azure.resourcemanager.netapp.models.ReplicationMirrorState;
import com.azure.resourcemanager.netapp.models.ReplicationSchedule;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ReplicationInner
implements JsonSerializable<ReplicationInner> {
    private String replicationId;
    private EndpointType endpointType;
    private ReplicationSchedule replicationSchedule;
    private String remoteVolumeResourceId;
    private String remoteVolumeRegion;
    private ReplicationMirrorState mirrorState;
    private OffsetDateTime replicationCreationTime;
    private OffsetDateTime replicationDeletionTime;
    private static final ClientLogger LOGGER = new ClientLogger(ReplicationInner.class);

    private ReplicationInner() {
    }

    public String replicationId() {
        return this.replicationId;
    }

    public EndpointType endpointType() {
        return this.endpointType;
    }

    public ReplicationSchedule replicationSchedule() {
        return this.replicationSchedule;
    }

    public String remoteVolumeResourceId() {
        return this.remoteVolumeResourceId;
    }

    public String remoteVolumeRegion() {
        return this.remoteVolumeRegion;
    }

    public ReplicationMirrorState mirrorState() {
        return this.mirrorState;
    }

    public OffsetDateTime replicationCreationTime() {
        return this.replicationCreationTime;
    }

    public OffsetDateTime replicationDeletionTime() {
        return this.replicationDeletionTime;
    }

    public void validate() {
        if (this.remoteVolumeResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property remoteVolumeResourceId in model ReplicationInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("remoteVolumeResourceId", this.remoteVolumeResourceId);
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeStringField("replicationSchedule", this.replicationSchedule == null ? null : this.replicationSchedule.toString());
        jsonWriter.writeStringField("remoteVolumeRegion", this.remoteVolumeRegion);
        return jsonWriter.writeEndObject();
    }

    public static ReplicationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationInner)jsonReader.readObject(reader -> {
            ReplicationInner deserializedReplicationInner = new ReplicationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("remoteVolumeResourceId".equals(fieldName)) {
                    deserializedReplicationInner.remoteVolumeResourceId = reader.getString();
                    continue;
                }
                if ("replicationId".equals(fieldName)) {
                    deserializedReplicationInner.replicationId = reader.getString();
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedReplicationInner.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("replicationSchedule".equals(fieldName)) {
                    deserializedReplicationInner.replicationSchedule = ReplicationSchedule.fromString(reader.getString());
                    continue;
                }
                if ("remoteVolumeRegion".equals(fieldName)) {
                    deserializedReplicationInner.remoteVolumeRegion = reader.getString();
                    continue;
                }
                if ("mirrorState".equals(fieldName)) {
                    deserializedReplicationInner.mirrorState = ReplicationMirrorState.fromString(reader.getString());
                    continue;
                }
                if ("replicationCreationTime".equals(fieldName)) {
                    deserializedReplicationInner.replicationCreationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("replicationDeletionTime".equals(fieldName)) {
                    deserializedReplicationInner.replicationDeletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationInner;
        });
    }
}

