/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.BackupPolicyProperties;
import com.azure.resourcemanager.netapp.models.VolumeBackups;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BackupPolicyInner
extends Resource {
    private BackupPolicyProperties innerProperties = new BackupPolicyProperties();
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(BackupPolicyInner.class);

    private BackupPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public BackupPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BackupPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String backupPolicyId() {
        return this.innerProperties() == null ? null : this.innerProperties().backupPolicyId();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Integer dailyBackupsToKeep() {
        return this.innerProperties() == null ? null : this.innerProperties().dailyBackupsToKeep();
    }

    public BackupPolicyInner withDailyBackupsToKeep(Integer dailyBackupsToKeep) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupPolicyProperties();
        }
        this.innerProperties().withDailyBackupsToKeep(dailyBackupsToKeep);
        return this;
    }

    public Integer weeklyBackupsToKeep() {
        return this.innerProperties() == null ? null : this.innerProperties().weeklyBackupsToKeep();
    }

    public BackupPolicyInner withWeeklyBackupsToKeep(Integer weeklyBackupsToKeep) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupPolicyProperties();
        }
        this.innerProperties().withWeeklyBackupsToKeep(weeklyBackupsToKeep);
        return this;
    }

    public Integer monthlyBackupsToKeep() {
        return this.innerProperties() == null ? null : this.innerProperties().monthlyBackupsToKeep();
    }

    public BackupPolicyInner withMonthlyBackupsToKeep(Integer monthlyBackupsToKeep) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupPolicyProperties();
        }
        this.innerProperties().withMonthlyBackupsToKeep(monthlyBackupsToKeep);
        return this;
    }

    public Integer volumesAssigned() {
        return this.innerProperties() == null ? null : this.innerProperties().volumesAssigned();
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public BackupPolicyInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupPolicyProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public List<VolumeBackups> volumeBackups() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeBackups();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model BackupPolicyInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BackupPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (BackupPolicyInner)((Object)jsonReader.readObject(reader -> {
            BackupPolicyInner deserializedBackupPolicyInner = new BackupPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackupPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackupPolicyInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBackupPolicyInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBackupPolicyInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackupPolicyInner.innerProperties = BackupPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedBackupPolicyInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBackupPolicyInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupPolicyInner;
        }));
    }
}

