/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.fluent.NetAppManagementClient;
import com.azure.resourcemanager.netapp.implementation.AccountsImpl;
import com.azure.resourcemanager.netapp.implementation.BackupPoliciesImpl;
import com.azure.resourcemanager.netapp.implementation.BackupVaultsImpl;
import com.azure.resourcemanager.netapp.implementation.BackupsImpl;
import com.azure.resourcemanager.netapp.implementation.BackupsUnderAccountsImpl;
import com.azure.resourcemanager.netapp.implementation.BackupsUnderBackupVaultsImpl;
import com.azure.resourcemanager.netapp.implementation.BackupsUnderVolumesImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientBuilder;
import com.azure.resourcemanager.netapp.implementation.NetAppResourceQuotaLimitsAccountsImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppResourceQuotaLimitsImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppResourceRegionInfosImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppResourceUsagesImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppResourcesImpl;
import com.azure.resourcemanager.netapp.implementation.OperationsImpl;
import com.azure.resourcemanager.netapp.implementation.PoolsImpl;
import com.azure.resourcemanager.netapp.implementation.SnapshotPoliciesImpl;
import com.azure.resourcemanager.netapp.implementation.SnapshotsImpl;
import com.azure.resourcemanager.netapp.implementation.SubvolumesImpl;
import com.azure.resourcemanager.netapp.implementation.VolumeGroupsImpl;
import com.azure.resourcemanager.netapp.implementation.VolumeQuotaRulesImpl;
import com.azure.resourcemanager.netapp.implementation.VolumesImpl;
import com.azure.resourcemanager.netapp.models.Accounts;
import com.azure.resourcemanager.netapp.models.BackupPolicies;
import com.azure.resourcemanager.netapp.models.BackupVaults;
import com.azure.resourcemanager.netapp.models.Backups;
import com.azure.resourcemanager.netapp.models.BackupsUnderAccounts;
import com.azure.resourcemanager.netapp.models.BackupsUnderBackupVaults;
import com.azure.resourcemanager.netapp.models.BackupsUnderVolumes;
import com.azure.resourcemanager.netapp.models.NetAppResourceQuotaLimits;
import com.azure.resourcemanager.netapp.models.NetAppResourceQuotaLimitsAccounts;
import com.azure.resourcemanager.netapp.models.NetAppResourceRegionInfos;
import com.azure.resourcemanager.netapp.models.NetAppResourceUsages;
import com.azure.resourcemanager.netapp.models.NetAppResources;
import com.azure.resourcemanager.netapp.models.Operations;
import com.azure.resourcemanager.netapp.models.Pools;
import com.azure.resourcemanager.netapp.models.SnapshotPolicies;
import com.azure.resourcemanager.netapp.models.Snapshots;
import com.azure.resourcemanager.netapp.models.Subvolumes;
import com.azure.resourcemanager.netapp.models.VolumeGroups;
import com.azure.resourcemanager.netapp.models.VolumeQuotaRules;
import com.azure.resourcemanager.netapp.models.Volumes;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class NetAppFilesManager {
    private Operations operations;
    private NetAppResourceQuotaLimitsAccounts netAppResourceQuotaLimitsAccounts;
    private VolumeGroups volumeGroups;
    private Backups backups;
    private Volumes volumes;
    private Snapshots snapshots;
    private SnapshotPolicies snapshotPolicies;
    private BackupPolicies backupPolicies;
    private VolumeQuotaRules volumeQuotaRules;
    private BackupVaults backupVaults;
    private NetAppResourceQuotaLimits netAppResourceQuotaLimits;
    private NetAppResourceRegionInfos netAppResourceRegionInfos;
    private Accounts accounts;
    private BackupsUnderAccounts backupsUnderAccounts;
    private Pools pools;
    private BackupsUnderBackupVaults backupsUnderBackupVaults;
    private BackupsUnderVolumes backupsUnderVolumes;
    private Subvolumes subvolumes;
    private NetAppResources netAppResources;
    private NetAppResourceUsages netAppResourceUsages;
    private final NetAppManagementClient clientObject;

    private NetAppFilesManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new NetAppManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static NetAppFilesManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return NetAppFilesManager.configure().authenticate(credential, profile);
    }

    public static NetAppFilesManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new NetAppFilesManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public NetAppResourceQuotaLimitsAccounts netAppResourceQuotaLimitsAccounts() {
        if (this.netAppResourceQuotaLimitsAccounts == null) {
            this.netAppResourceQuotaLimitsAccounts = new NetAppResourceQuotaLimitsAccountsImpl(this.clientObject.getNetAppResourceQuotaLimitsAccounts(), this);
        }
        return this.netAppResourceQuotaLimitsAccounts;
    }

    public VolumeGroups volumeGroups() {
        if (this.volumeGroups == null) {
            this.volumeGroups = new VolumeGroupsImpl(this.clientObject.getVolumeGroups(), this);
        }
        return this.volumeGroups;
    }

    public Backups backups() {
        if (this.backups == null) {
            this.backups = new BackupsImpl(this.clientObject.getBackups(), this);
        }
        return this.backups;
    }

    public Volumes volumes() {
        if (this.volumes == null) {
            this.volumes = new VolumesImpl(this.clientObject.getVolumes(), this);
        }
        return this.volumes;
    }

    public Snapshots snapshots() {
        if (this.snapshots == null) {
            this.snapshots = new SnapshotsImpl(this.clientObject.getSnapshots(), this);
        }
        return this.snapshots;
    }

    public SnapshotPolicies snapshotPolicies() {
        if (this.snapshotPolicies == null) {
            this.snapshotPolicies = new SnapshotPoliciesImpl(this.clientObject.getSnapshotPolicies(), this);
        }
        return this.snapshotPolicies;
    }

    public BackupPolicies backupPolicies() {
        if (this.backupPolicies == null) {
            this.backupPolicies = new BackupPoliciesImpl(this.clientObject.getBackupPolicies(), this);
        }
        return this.backupPolicies;
    }

    public VolumeQuotaRules volumeQuotaRules() {
        if (this.volumeQuotaRules == null) {
            this.volumeQuotaRules = new VolumeQuotaRulesImpl(this.clientObject.getVolumeQuotaRules(), this);
        }
        return this.volumeQuotaRules;
    }

    public BackupVaults backupVaults() {
        if (this.backupVaults == null) {
            this.backupVaults = new BackupVaultsImpl(this.clientObject.getBackupVaults(), this);
        }
        return this.backupVaults;
    }

    public NetAppResourceQuotaLimits netAppResourceQuotaLimits() {
        if (this.netAppResourceQuotaLimits == null) {
            this.netAppResourceQuotaLimits = new NetAppResourceQuotaLimitsImpl(this.clientObject.getNetAppResourceQuotaLimits(), this);
        }
        return this.netAppResourceQuotaLimits;
    }

    public NetAppResourceRegionInfos netAppResourceRegionInfos() {
        if (this.netAppResourceRegionInfos == null) {
            this.netAppResourceRegionInfos = new NetAppResourceRegionInfosImpl(this.clientObject.getNetAppResourceRegionInfos(), this);
        }
        return this.netAppResourceRegionInfos;
    }

    public Accounts accounts() {
        if (this.accounts == null) {
            this.accounts = new AccountsImpl(this.clientObject.getAccounts(), this);
        }
        return this.accounts;
    }

    public BackupsUnderAccounts backupsUnderAccounts() {
        if (this.backupsUnderAccounts == null) {
            this.backupsUnderAccounts = new BackupsUnderAccountsImpl(this.clientObject.getBackupsUnderAccounts(), this);
        }
        return this.backupsUnderAccounts;
    }

    public Pools pools() {
        if (this.pools == null) {
            this.pools = new PoolsImpl(this.clientObject.getPools(), this);
        }
        return this.pools;
    }

    public BackupsUnderBackupVaults backupsUnderBackupVaults() {
        if (this.backupsUnderBackupVaults == null) {
            this.backupsUnderBackupVaults = new BackupsUnderBackupVaultsImpl(this.clientObject.getBackupsUnderBackupVaults(), this);
        }
        return this.backupsUnderBackupVaults;
    }

    public BackupsUnderVolumes backupsUnderVolumes() {
        if (this.backupsUnderVolumes == null) {
            this.backupsUnderVolumes = new BackupsUnderVolumesImpl(this.clientObject.getBackupsUnderVolumes(), this);
        }
        return this.backupsUnderVolumes;
    }

    public Subvolumes subvolumes() {
        if (this.subvolumes == null) {
            this.subvolumes = new SubvolumesImpl(this.clientObject.getSubvolumes(), this);
        }
        return this.subvolumes;
    }

    public NetAppResources netAppResources() {
        if (this.netAppResources == null) {
            this.netAppResources = new NetAppResourcesImpl(this.clientObject.getNetAppResources(), this);
        }
        return this.netAppResources;
    }

    public NetAppResourceUsages netAppResourceUsages() {
        if (this.netAppResourceUsages == null) {
            this.netAppResourceUsages = new NetAppResourceUsagesImpl(this.clientObject.getNetAppResourceUsages(), this);
        }
        return this.netAppResourceUsages;
    }

    public NetAppManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-netapp.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public NetAppFilesManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.netapp").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new NetAppFilesManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

