/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.fluent.models.NeonRoleInner;
import java.io.IOException;
import java.util.List;

public final class NeonRoleListResult
implements JsonSerializable<NeonRoleListResult> {
    private List<NeonRoleInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(NeonRoleListResult.class);

    private NeonRoleListResult() {
    }

    public List<NeonRoleInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model NeonRoleListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static NeonRoleListResult fromJson(JsonReader jsonReader) throws IOException {
        return (NeonRoleListResult)jsonReader.readObject(reader -> {
            NeonRoleListResult deserializedNeonRoleListResult = new NeonRoleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNeonRoleListResult.value = value = reader.readArray(reader1 -> NeonRoleInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNeonRoleListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNeonRoleListResult;
        });
    }
}

