/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.neonpostgres.fluent.BranchesClient;
import com.azure.resourcemanager.neonpostgres.fluent.ComputesClient;
import com.azure.resourcemanager.neonpostgres.fluent.EndpointsClient;
import com.azure.resourcemanager.neonpostgres.fluent.NeonDatabasesClient;
import com.azure.resourcemanager.neonpostgres.fluent.NeonPostgresManagementClient;
import com.azure.resourcemanager.neonpostgres.fluent.NeonRolesClient;
import com.azure.resourcemanager.neonpostgres.fluent.OperationsClient;
import com.azure.resourcemanager.neonpostgres.fluent.OrganizationsClient;
import com.azure.resourcemanager.neonpostgres.fluent.ProjectsClient;
import com.azure.resourcemanager.neonpostgres.implementation.BranchesClientImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ComputesClientImpl;
import com.azure.resourcemanager.neonpostgres.implementation.EndpointsClientImpl;
import com.azure.resourcemanager.neonpostgres.implementation.NeonDatabasesClientImpl;
import com.azure.resourcemanager.neonpostgres.implementation.NeonPostgresManagementClientBuilder;
import com.azure.resourcemanager.neonpostgres.implementation.NeonRolesClientImpl;
import com.azure.resourcemanager.neonpostgres.implementation.OperationsClientImpl;
import com.azure.resourcemanager.neonpostgres.implementation.OrganizationsClientImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ProjectsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=NeonPostgresManagementClientBuilder.class)
public final class NeonPostgresManagementClientImpl
implements NeonPostgresManagementClient {
    private final String endpoint;
    private final String apiVersion;
    private final String subscriptionId;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final OrganizationsClient organizations;
    private final ProjectsClient projects;
    private final BranchesClient branches;
    private final ComputesClient computes;
    private final NeonDatabasesClient neonDatabases;
    private final NeonRolesClient neonRoles;
    private final EndpointsClient endpoints;
    private static final ClientLogger LOGGER = new ClientLogger(NeonPostgresManagementClientImpl.class);

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public OrganizationsClient getOrganizations() {
        return this.organizations;
    }

    @Override
    public ProjectsClient getProjects() {
        return this.projects;
    }

    @Override
    public BranchesClient getBranches() {
        return this.branches;
    }

    @Override
    public ComputesClient getComputes() {
        return this.computes;
    }

    @Override
    public NeonDatabasesClient getNeonDatabases() {
        return this.neonDatabases;
    }

    @Override
    public NeonRolesClient getNeonRoles() {
        return this.neonRoles;
    }

    @Override
    public EndpointsClient getEndpoints() {
        return this.endpoints;
    }

    NeonPostgresManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint, String subscriptionId) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.subscriptionId = subscriptionId;
        this.apiVersion = "2025-03-01";
        this.operations = new OperationsClientImpl(this);
        this.organizations = new OrganizationsClientImpl(this);
        this.projects = new ProjectsClientImpl(this);
        this.branches = new BranchesClientImpl(this);
        this.computes = new ComputesClientImpl(this);
        this.neonDatabases = new NeonDatabasesClientImpl(this);
        this.neonRoles = new NeonRolesClientImpl(this);
        this.endpoints = new EndpointsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

